/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.DoubleValue;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.model.InvalidElementListException;

public class NormalizationUtil {
    private NormalizationUtil() {
    }

    public static FieldValue normalize(NormContinuous normContinuous, FieldValue value) {
        Number result = NormalizationUtil.normalize(normContinuous, value.asNumber());
        return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, result);
    }

    public static Number normalize(NormContinuous normContinuous, Number value) {
        Value doubleValue = new DoubleValue(value);
        if ((doubleValue = NormalizationUtil.normalize(normContinuous, doubleValue)) == null) {
            return null;
        }
        return doubleValue.getValue();
    }

    public static <V extends Number> Value<V> normalize(NormContinuous normContinuous, Value<V> value) {
        List<LinearNorm> linearNorms = NormalizationUtil.ensureLinearNorms(normContinuous);
        LinearNorm start = linearNorms.get(0);
        LinearNorm end = linearNorms.get(linearNorms.size() - 1);
        Number startOrig = start.requireOrig();
        Number endOrig = end.requireOrig();
        if (value.compareTo(startOrig) < 0 || value.compareTo(endOrig) > 0) {
            OutlierTreatmentMethod outlierTreatmentMethod = normContinuous.getOutliers();
            switch (outlierTreatmentMethod) {
                case AS_IS: {
                    if (value.compareTo(startOrig) < 0) {
                        end = linearNorms.get(1);
                        endOrig = end.requireOrig();
                        break;
                    }
                    start = linearNorms.get(linearNorms.size() - 2);
                    startOrig = start.requireOrig();
                    break;
                }
                case AS_MISSING_VALUES: {
                    return null;
                }
                case AS_EXTREME_VALUES: {
                    if (value.compareTo(startOrig) < 0) {
                        Number startNorm = start.requireNorm();
                        return value.restrict(startNorm, Double.POSITIVE_INFINITY);
                    }
                    Number endNorm = end.requireNorm();
                    return value.restrict(Double.NEGATIVE_INFINITY, endNorm);
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)normContinuous, (Enum<?>)outlierTreatmentMethod);
                }
            }
        } else {
            int max = linearNorms.size() - 1;
            for (int i = 1; i < max; ++i) {
                LinearNorm linearNorm = linearNorms.get(i);
                Number orig = linearNorm.requireOrig();
                if (value.compareTo(orig) >= 0) {
                    start = linearNorm;
                    startOrig = orig;
                    continue;
                }
                if (value.compareTo(orig) > 0) continue;
                end = linearNorm;
                endOrig = orig;
                break;
            }
        }
        Number startNorm = start.requireNorm();
        Number endNorm = end.requireNorm();
        return value.normalize(startOrig, startNorm, endOrig, endNorm);
    }

    public static Number denormalize(NormContinuous normContinuous, Number value) {
        Value doubleValue = new DoubleValue(value);
        doubleValue = NormalizationUtil.denormalize(normContinuous, doubleValue);
        return doubleValue.getValue();
    }

    public static <V extends Number> Value<V> denormalize(NormContinuous normContinuous, Value<V> value) {
        List<LinearNorm> linearNorms = NormalizationUtil.ensureLinearNorms(normContinuous);
        LinearNorm start = linearNorms.get(0);
        LinearNorm end = linearNorms.get(linearNorms.size() - 1);
        Number startNorm = start.requireNorm();
        Number endNorm = end.requireNorm();
        int max = linearNorms.size() - 1;
        for (int i = 1; i < max; ++i) {
            LinearNorm linearNorm = linearNorms.get(i);
            Number norm = linearNorm.requireNorm();
            if (value.compareTo(norm) >= 0) {
                start = linearNorm;
                startNorm = norm;
                continue;
            }
            if (value.compareTo(norm) > 0) continue;
            end = linearNorm;
            endNorm = norm;
            break;
        }
        Number startOrig = start.requireOrig();
        Number endOrig = end.requireOrig();
        return value.denormalize(startOrig, startNorm, endOrig, endNorm);
    }

    private static List<LinearNorm> ensureLinearNorms(NormContinuous normContinuous) {
        List linearNorms = normContinuous.requireLinearNorms();
        if (linearNorms.size() < 2) {
            throw new InvalidElementListException(linearNorms);
        }
        return linearNorms;
    }
}

