/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.tableaction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.talend.components.common.tableaction.TableActionConfig;

public abstract class TableAction {
    private TableActionConfig config = new TableActionConfig();
    private Map<String, String> dbTypeMap = new HashMap<String, String>();

    public abstract List<String> getQueries() throws Exception;

    public void setConfig(TableActionConfig config) {
        this.config = config;
    }

    public void setDbTypeMap(Map<String, String> dbTypeMap) {
        this.dbTypeMap = dbTypeMap;
    }

    public TableActionConfig getConfig() {
        return this.config;
    }

    public Map<String, String> getDbTypeMap() {
        return this.dbTypeMap;
    }

    public String escape(String value) {
        if (!this.getConfig().SQL_ESCAPE_ENABLED || this.isEscaped(value)) {
            return value;
        }
        return this.getConfig().SQL_ESCAPE + value + this.getConfig().SQL_ESCAPE;
    }

    public boolean isEscaped(String value) {
        return value.startsWith(this.getConfig().SQL_ESCAPE) && value.endsWith(this.getConfig().SQL_ESCAPE);
    }

    public String buildFullTableName(String[] fullTableName, String sep, boolean escape) {
        StringBuilder name = new StringBuilder();
        boolean first = true;
        for (String n : fullTableName) {
            if (n == null) continue;
            if (!first) {
                name.append(sep);
            }
            first = false;
            n = this.updateCaseIdentifier(n);
            if (escape) {
                n = this.escape(n);
            }
            name.append(n);
        }
        return name.toString();
    }

    public String updateCaseIdentifier(String identifier) {
        if (this.getConfig().SQL_UPPERCASE_IDENTIFIER) {
            return identifier.toUpperCase();
        }
        if (this.getConfig().SQL_LOWERCASE_IDENTIFIER) {
            return identifier.toLowerCase();
        }
        return identifier;
    }

    public static enum TableActionEnum {
        NONE(false),
        DROP_CREATE(true),
        CREATE(true),
        CREATE_IF_NOT_EXISTS(true),
        DROP_IF_EXISTS_AND_CREATE(true),
        CLEAR(false),
        TRUNCATE(false);

        boolean create;

        private TableActionEnum(boolean create) {
            this.create = create;
        }

        public boolean isCreateTableAction() {
            return this.create;
        }
    }
}

