/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.tableaction;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.config.jdbc.DbmsType;
import org.talend.components.common.tableaction.ConvertAvroTypeToSQL;
import org.talend.components.common.tableaction.TableAction;

public class DefaultSQLCreateTableAction
extends TableAction {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSQLCreateTableAction.class);
    private String[] fullTableName;
    private Schema schema;
    private boolean drop;
    private boolean createIfNotExists;
    private boolean dropIfExists;

    public DefaultSQLCreateTableAction(String[] fullTableName, Schema schema, boolean createIfNotExists, boolean drop, boolean dropIfExists) {
        if (fullTableName == null || fullTableName.length < 1) {
            throw new InvalidParameterException("Table name can't be null or empty");
        }
        this.fullTableName = fullTableName;
        this.schema = schema;
        this.createIfNotExists = createIfNotExists;
        this.drop = drop || dropIfExists;
        this.dropIfExists = dropIfExists;
    }

    @Override
    public List<String> getQueries() throws Exception {
        ArrayList<String> queries = new ArrayList<String>();
        if (this.drop) {
            queries.add(this.getDropTableQuery());
        }
        queries.add(this.getCreateTableQuery());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated SQL queries for create fullTableName:");
            for (String q : queries) {
                LOG.debug(q);
            }
        }
        return queries;
    }

    private String getDropTableQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getConfig().SQL_DROP_TABLE_PREFIX);
        sb.append(this.getConfig().SQL_DROP_TABLE);
        sb.append(" ");
        if (this.dropIfExists) {
            sb.append(this.getConfig().SQL_DROP_TABLE_IF_EXISITS);
            sb.append(" ");
        }
        sb.append(this.buildFullTableName(this.fullTableName, this.getConfig().SQL_FULL_NAME_SEGMENT_SEP, true));
        sb.append(this.getConfig().SQL_DROP_TABLE_SUFFIX);
        return sb.toString();
    }

    private String getCreateTableQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getConfig().SQL_CREATE_TABLE_PREFIX);
        sb.append(this.getConfig().SQL_CREATE_TABLE);
        sb.append(" ");
        if (this.createIfNotExists) {
            sb.append(this.getConfig().SQL_CREATE_TABLE_IF_NOT_EXISTS);
            sb.append(" ");
        }
        sb.append(this.buildFullTableName(this.fullTableName, this.getConfig().SQL_FULL_NAME_SEGMENT_SEP, true));
        sb.append(" ");
        sb.append(this.getConfig().SQL_CREATE_TABLE_FIELD_ENCLOSURE_START);
        sb.append((CharSequence)this.buildColumns());
        sb.append(this.getConfig().SQL_CREATE_TABLE_FIELD_ENCLOSURE_END);
        sb.append(this.getConfig().SQL_CREATE_TABLE_SUFFIX);
        return sb.toString();
    }

    private StringBuilder buildColumns() {
        ConvertAvroTypeToSQL convertAvroToSQL = new ConvertAvroTypeToSQL(this.getConfig());
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        List fields = this.schema.getFields();
        ArrayList<String> keys = new ArrayList<String>();
        for (Schema.Field f : fields) {
            String name;
            if (!first) {
                sb.append(this.getConfig().SQL_CREATE_TABLE_FIELD_SEP);
            }
            String sDBLength = f.getProp("talend.field.length");
            String sDBName = f.getProp("talend.field.dbColumnName");
            String sDBType = f.getProp("talend.field.dbType");
            String sDBDefault = f.getProp("talend.field.default");
            String sDBPrecision = f.getProp("talend.field.precision");
            boolean sDBIsKey = Boolean.valueOf(f.getProp("talend.field.isKey"));
            boolean sDBNullable = this.isNullable(f.schema());
            String string = name = sDBName == null ? f.name() : sDBName;
            if (sDBIsKey) {
                keys.add(name);
            }
            sb.append(this.escape(this.updateCaseIdentifier(name)));
            sb.append(" ");
            if (DefaultSQLCreateTableAction.isNullOrEmpty(sDBType)) {
                sDBType = this.getDbTypeMap().get(f.name());
            }
            if (DefaultSQLCreateTableAction.isNullOrEmpty(sDBType)) {
                sDBType = convertAvroToSQL.convertToSQLTypeString(f.schema());
            }
            sb.append(this.updateCaseIdentifier(sDBType));
            this.buildLengthPrecision(sb, f, sDBType);
            if (!sDBNullable) {
                sb.append(this.getConfig().SQL_CREATE_TABLE_NOT_NULL);
            }
            if (this.getConfig().SQL_CREATE_TABLE_DEFAULT_ENABLED && !DefaultSQLCreateTableAction.isNullOrEmpty(sDBDefault)) {
                sb.append(" ");
                sb.append(this.getConfig().SQL_CREATE_TABLE_DEFAULT);
                sb.append(" ");
                sb.append(sDBDefault);
            }
            first = false;
        }
        if (this.getConfig().SQL_CREATE_TABLE_CONSTRAINT_ENABLED && keys.size() > 0) {
            sb.append(this.getConfig().SQL_CREATE_TABLE_FIELD_SEP);
            sb.append(this.getConfig().SQL_CREATE_TABLE_CONSTRAINT);
            sb.append(" ");
            sb.append(this.escape(this.getConfig().SQL_CREATE_TABLE_PRIMARY_KEY_PREFIX + this.buildFullTableName(this.fullTableName, this.getConfig().SQL_PRIMARY_KEY_FULL_NAME_SEGMENT_SEP, false)));
            sb.append(" ");
            sb.append(this.getConfig().SQL_CREATE_TABLE_PRIMARY_KEY);
            sb.append(" ");
            sb.append(this.getConfig().SQL_CREATE_TABLE_PRIMARY_KEY_ENCLOSURE_START);
            first = true;
            for (String k : keys) {
                if (!first) {
                    sb.append(this.getConfig().SQL_CREATE_TABLE_FIELD_SEP);
                }
                sb.append(this.escape(this.updateCaseIdentifier(k)));
                first = false;
            }
            sb.append(this.getConfig().SQL_CREATE_TABLE_PRIMARY_KEY_ENCLOSURE_END);
        }
        return sb;
    }

    private void buildLengthPrecision(StringBuilder sb, Schema.Field field, String dbType) {
        String length = field.getProp("talend.field.length");
        String precision = field.getProp("talend.field.precision");
        DbmsType dbmsType = this.getConfig().DB_TYPES.get(dbType);
        boolean ignoreLength = false;
        boolean ignorePrecision = false;
        if (dbmsType != null) {
            ignoreLength = dbmsType.isIgnoreLength();
            ignorePrecision = dbmsType.isIgnorePrecision();
        }
        if (this.getConfig().SQL_CREATE_TABLE_LENGTH_ENABLED && !ignoreLength && !DefaultSQLCreateTableAction.isNullOrEmpty(length)) {
            sb.append(this.getConfig().SQL_CREATE_TABLE_LENGTH_START);
            sb.append(length);
            if (this.getConfig().SQL_CREATE_TABLE_PRECISION_ENABLED && !ignorePrecision && !DefaultSQLCreateTableAction.isNullOrEmpty(precision)) {
                sb.append(this.getConfig().SQL_CREATE_TABLE_PRECISION_SEP);
                sb.append(precision);
            }
            sb.append(this.getConfig().SQL_CREATE_TABLE_LENGTH_END);
        }
    }

    private static boolean isNullOrEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().isEmpty();
    }

    private boolean isNullable(Schema schema) {
        Schema.Type type = schema.getType();
        if (type == Schema.Type.UNION) {
            for (Schema s : schema.getTypes()) {
                if (s.getType() != Schema.Type.NULL) continue;
                return true;
            }
        }
        return false;
    }
}

