/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.tableaction;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.talend.components.common.tableaction.TableActionConfig;
import org.talend.daikon.avro.AvroRegistry;

public class ConvertAvroTypeToSQL {
    private static final Map<Integer, String> SQLTypesMap = new HashMap<Integer, String>();
    private static final AvroRegistry avroRegistry;
    private TableActionConfig config;

    public ConvertAvroTypeToSQL(TableActionConfig config) {
        this.config = config;
        Set<Map.Entry<Integer, String>> entries = this.config.CUSTOMIZE_SQLTYPE_TYPENAME.entrySet();
        for (Map.Entry<Integer, String> e : entries) {
            SQLTypesMap.put(e.getKey(), e.getValue());
        }
    }

    public String convertToSQLTypeString(Schema schema) {
        int sqlType = this.convertToSQLType(schema);
        String sType = SQLTypesMap.get(sqlType);
        if (sType == null) {
            throw new UnsupportedOperationException("Can't find " + sqlType + " sql type. You may add it into TableActionConfig.CUSTOMIZE_SQLTYPE_TYPENAME.");
        }
        return sType;
    }

    public int convertToSQLType(Schema schema) {
        Schema.Type type = schema.getType();
        LogicalType logicalType = schema.getLogicalType();
        String javaType = schema.getProp("java-class");
        if (logicalType == null && type == Schema.Type.UNION) {
            for (Schema s : schema.getTypes()) {
                logicalType = null;
                if (s.getType() == Schema.Type.NULL) continue;
                type = s.getType();
                javaType = s.getProp("java-class");
                logicalType = s.getLogicalType();
                if (javaType != null || logicalType != null) break;
                type = s.getType();
                break;
            }
        }
        int sqlType = 0;
        sqlType = logicalType != null ? this.convertAvroLogicialType(logicalType) : (javaType == null ? this.convertRawAvroType(type) : this.convertTalendAvroType(javaType));
        if (this.config.CONVERT_SQLTYPE_TO_ANOTHER_SQLTYPE.containsKey(sqlType)) {
            sqlType = this.config.CONVERT_SQLTYPE_TO_ANOTHER_SQLTYPE.get(sqlType);
        }
        return sqlType;
    }

    private int convertRawAvroType(Schema.Type type) {
        Integer sqlType = this.config.CONVERT_AVROTYPE_TO_SQLTYPE.get(type);
        if (sqlType != null) {
            return sqlType;
        }
        switch (type) {
            case STRING: {
                sqlType = 12;
                break;
            }
            case BYTES: {
                sqlType = 2004;
                break;
            }
            case INT: {
                sqlType = 4;
                break;
            }
            case LONG: {
                sqlType = 4;
                break;
            }
            case FLOAT: {
                sqlType = 2;
                break;
            }
            case DOUBLE: {
                sqlType = 2;
                break;
            }
            case BOOLEAN: {
                sqlType = 16;
                break;
            }
            default: {
                throw new UnsupportedOperationException(type + " Avro type not supported");
            }
        }
        return sqlType;
    }

    private int convertAvroLogicialType(LogicalType logicalType) {
        Integer sqlType = this.config.CONVERT_LOGICALTYPE_TO_SQLTYPE.get(logicalType);
        if (sqlType != null) {
            return sqlType;
        }
        if (logicalType == LogicalTypes.timestampMillis()) {
            sqlType = 93;
        } else if (logicalType instanceof LogicalTypes.Decimal) {
            sqlType = 2;
        } else if (logicalType == LogicalTypes.date()) {
            sqlType = 91;
        } else if (logicalType == LogicalTypes.uuid()) {
            sqlType = 12;
        } else if (logicalType == LogicalTypes.timestampMicros()) {
            sqlType = 93;
        } else if (logicalType == LogicalTypes.timeMillis()) {
            sqlType = 92;
        } else if (logicalType == LogicalTypes.timeMicros()) {
            sqlType = 92;
        } else {
            throw new UnsupportedOperationException("Logical type " + logicalType + " not supported");
        }
        return sqlType;
    }

    private int convertTalendAvroType(String javaType) {
        Integer sqlType = this.config.CONVERT_JAVATYPE_TO_SQLTYPE.get(javaType);
        if (sqlType != null) {
            return sqlType;
        }
        switch (javaType) {
            case "java.lang.Byte": {
                sqlType = 5;
                break;
            }
            case "java.lang.Short": {
                sqlType = 5;
                break;
            }
            case "java.lang.Character": {
                sqlType = 12;
                break;
            }
            case "java.util.Date": {
                sqlType = 91;
                break;
            }
            case "java.math.BigDecimal": {
                sqlType = 2;
                break;
            }
            default: {
                throw new UnsupportedOperationException(javaType + " class can't be converted to SQL type.");
            }
        }
        return sqlType;
    }

    static {
        Field[] fields = Types.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                String name = fields[i].getName();
                Integer value = (Integer)fields[i].get(null);
                SQLTypesMap.put(value, name);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        avroRegistry = new AvroRegistry();
    }
}

