/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.runtime;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.talend.components.common.runtime.FastDateParser;

public class ParserUtils {
    public static List<String> parseToList(String listStr, String fieldSep) {
        if (listStr == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (fieldSep == null || "".equals(fieldSep) || !listStr.startsWith("[") || !listStr.endsWith("]")) {
            list.add(listStr);
            return list;
        }
        String strTemp = listStr.substring(1, listStr.length() - 1);
        for (String str : strTemp.split(fieldSep, -1)) {
            list.add(str);
        }
        return list;
    }

    public static String parseListToString(List<String> strList, String fieldSep) {
        if (strList == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (int i = 0; i < strList.size(); ++i) {
            if (i != 0) {
                result.append(fieldSep);
            }
            result.append(strList.get(i));
        }
        result.append("]");
        return result.toString();
    }

    public static Character parseToCharacter(String charStr) {
        if (charStr == null) {
            return null;
        }
        return Character.valueOf(charStr.charAt(0));
    }

    public static Byte parseToByte(String byteStr, boolean isDecode) {
        if (byteStr == null) {
            return null;
        }
        if (isDecode) {
            return (byte)Byte.decode(byteStr);
        }
        return Byte.parseByte(byteStr);
    }

    public static Double parseToDouble(String doubleStr) {
        if (doubleStr == null) {
            return null;
        }
        return Double.parseDouble(doubleStr);
    }

    public static Float parseToFloat(String floatStr) {
        if (floatStr == null) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(floatStr));
    }

    public static Integer parseToInteger(String intStr, boolean isDecode) {
        if (intStr == null) {
            return null;
        }
        if (isDecode) {
            return (int)Integer.decode(intStr);
        }
        return Integer.parseInt(intStr);
    }

    public static Short parseToShort(String s, boolean isDecode) {
        if (s == null) {
            return null;
        }
        if (isDecode) {
            return (short)Short.decode(s);
        }
        return Short.parseShort(s);
    }

    public static Long parseToLong(String longStr, boolean isDecode) {
        if (longStr == null) {
            return null;
        }
        if (isDecode) {
            return (long)Long.decode(longStr);
        }
        return Long.parseLong(longStr);
    }

    public static Boolean parseToBoolean(String booleanStr) {
        if (booleanStr == null) {
            return null;
        }
        if (booleanStr.equals("1")) {
            return true;
        }
        return Boolean.parseBoolean(booleanStr);
    }

    public static synchronized Date parseToDate(String stringDate, String pattern, boolean isLenient) {
        if (stringDate != null) {
            stringDate = stringDate.trim();
        }
        if (stringDate == null || stringDate.length() == 0) {
            return null;
        }
        if (pattern == null) {
            pattern = "dd-MM-yyyy";
        }
        Date date = null;
        if (pattern.equals("yyyy-MM-dd'T'HH:mm:ss'000Z'")) {
            if (!stringDate.endsWith("000Z")) {
                throw new RuntimeException("Unparseable date: \"" + stringDate + "\"");
            }
            pattern = "yyyy-MM-dd'T'HH:mm:ss";
            stringDate = stringDate.substring(0, stringDate.lastIndexOf("000Z"));
        }
        DateFormat format = FastDateParser.getInstance(pattern, isLenient);
        ParsePosition pp = new ParsePosition(0);
        pp.setIndex(0);
        date = format.parse(stringDate, pp);
        if (pp.getIndex() != stringDate.length() || date == null) {
            throw new RuntimeException("Unparseable date: \"" + stringDate + "\"");
        }
        return date;
    }

    public static String transformNumberString(String numberString, Character thousandsSeparator, Character decimalSeparator) {
        if (numberString == null) {
            return null;
        }
        String result = numberString;
        if (thousandsSeparator != null) {
            result = StringUtils.replace((String)numberString, (String)thousandsSeparator.toString(), (String)"");
        }
        if (decimalSeparator != null) {
            result = result.replace(decimalSeparator.charValue(), '.');
        }
        return result;
    }
}

