/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.runtime;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileRuntimeHelper {
    public static boolean compareInTextMode(String srcFilePath, String referFilePath, String encoding) throws IOException {
        BufferedReader srcFile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFilePath), encoding));
        BufferedReader referFile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(referFilePath), encoding));
        String contentSrc = null;
        String contentRefer = null;
        boolean compareResult = true;
        while ((contentSrc = srcFile.readLine()) != null && (contentRefer = referFile.readLine()) != null) {
            if (contentSrc.compareTo(contentRefer) == 0) continue;
            compareResult = false;
            break;
        }
        if (compareResult) {
            if (contentSrc == null) {
                contentRefer = referFile.readLine();
            }
            if (contentSrc != null || contentRefer != null) {
                compareResult = false;
            }
        }
        srcFile.close();
        referFile.close();
        return compareResult;
    }

    public static boolean compareInBinaryMode(String srcFilePath, String referFilePath) throws IOException {
        boolean compareResult = true;
        FileChannel srcFileChannel = new FileInputStream(srcFilePath).getChannel();
        long fileLength = srcFileChannel.size();
        srcFileChannel.close();
        FileChannel referFileChannel = new FileInputStream(referFilePath).getChannel();
        long fileRefLength = referFileChannel.size();
        referFileChannel.close();
        if (fileLength != fileRefLength) {
            compareResult = false;
        }
        if (compareResult) {
            BufferedInputStream srcFile = new BufferedInputStream(new FileInputStream(srcFilePath));
            BufferedInputStream referFile = new BufferedInputStream(new FileInputStream(referFilePath));
            int contentSrc = -1;
            int contentRefer = -1;
            while ((contentSrc = srcFile.read()) != -1 && (contentRefer = referFile.read()) != -1) {
                if (contentSrc == contentRefer) continue;
                compareResult = false;
                break;
            }
            srcFile.close();
            referFile.close();
        }
        return compareResult;
    }

    protected static ZipInputStream createZipInputStream(Object source) throws IOException {
        ZipInputStream zipInputStream = null;
        if (source != null) {
            zipInputStream = source instanceof InputStream ? new ZipInputStream(new BufferedInputStream((InputStream)source)) : new ZipInputStream(new BufferedInputStream(new FileInputStream(String.valueOf(source))));
        }
        return zipInputStream;
    }

    public static ZipInputStream getZipInputStream(String fileName) throws IOException {
        return FileRuntimeHelper.createZipInputStream(fileName);
    }

    public static ZipInputStream getZipInputStream(InputStream stream) throws IOException {
        return FileRuntimeHelper.createZipInputStream(stream);
    }

    public static ZipEntry getCurrentZipEntry(ZipInputStream zipInputStream) throws IOException {
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null && zipEntry.isDirectory()) {
        }
        return zipEntry;
    }
}

