/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.runtime;

import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.component.runtime.Sink;
import org.talend.components.api.component.runtime.WriteOperation;
import org.talend.components.api.component.runtime.Writer;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.common.BulkFileProperties;
import org.talend.components.common.runtime.GenericIndexedRecordConverter;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.converter.IndexedRecordConverter;

public class BulkFileWriter
implements Writer<Result> {
    protected RuntimeContainer container;
    private WriteOperation<Result> writeOperation;
    private Result result;
    private Sink sink;
    protected BulkFileProperties bulkProperties;
    private String uId;
    private CsvWriter csvWriter;
    private char separator = (char)44;
    private String charset = "UTF-8";
    private boolean isAppend;
    private transient IndexedRecordConverter<IndexedRecord, IndexedRecord> factory;
    private boolean headerIsReady = false;
    private boolean fileIsEmpty = false;

    public BulkFileWriter(WriteOperation<Result> writeOperation, BulkFileProperties bulkProperties, RuntimeContainer container) {
        this.writeOperation = writeOperation;
        this.container = container;
        this.sink = writeOperation.getSink();
        this.bulkProperties = bulkProperties;
        this.isAppend = (Boolean)bulkProperties.append.getValue();
    }

    public void open(String uId) throws IOException {
        this.uId = uId;
        this.result = new Result(uId);
        String filepath = this.bulkProperties.bulkFilePath.getStringValue();
        if (filepath == null || filepath.isEmpty()) {
            throw new RuntimeException("Please set a valid value for \"Bulk File Path\" field.");
        }
        File file = new File(this.bulkProperties.bulkFilePath.getStringValue());
        file.getParentFile().mkdirs();
        this.csvWriter = new CsvWriter((java.io.Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file, this.isAppend), this.charset), this.separator);
        this.fileIsEmpty = file.length() == 0L;
    }

    public void write(Object datum) throws IOException {
        if (null == datum) {
            return;
        }
        if (!(this.headerIsReady || this.isAppend && !this.fileIsEmpty)) {
            Schema schema = new Schema.Parser().parse(this.bulkProperties.schema.schema.getStringValue());
            if (AvroUtils.isIncludeAllFields((Schema)schema) && datum instanceof IndexedRecord) {
                IndexedRecord record = (IndexedRecord)datum;
                schema = record.getSchema();
            }
            this.csvWriter.writeRecord(this.getHeaders(schema));
            this.headerIsReady = true;
        }
        List<String> values = this.getValues(datum);
        this.csvWriter.writeRecord(values.toArray(new String[values.size()]));
        ++this.result.totalCount;
    }

    public void flush() throws IOException {
        this.csvWriter.flush();
    }

    public Result close() throws IOException {
        this.flush();
        this.csvWriter.close();
        return this.result;
    }

    public WriteOperation<Result> getWriteOperation() {
        return this.writeOperation;
    }

    public String[] getHeaders(Schema schema) {
        ArrayList<String> headers = new ArrayList<String>();
        for (Schema.Field f : schema.getFields()) {
            headers.add(f.name());
        }
        return headers.toArray(new String[headers.size()]);
    }

    public List<String> getValues(Object datum) {
        IndexedRecord input = (IndexedRecord)this.getFactory(datum).convertToAvro((Object)((IndexedRecord)datum));
        ArrayList<String> values = new ArrayList<String>();
        for (Schema.Field f : input.getSchema().getFields()) {
            if (input.get(f.pos()) != null) {
                values.add(String.valueOf(input.get(f.pos())));
                continue;
            }
            values.add("");
        }
        return values;
    }

    public IndexedRecordConverter<IndexedRecord, IndexedRecord> getFactory(Object datum) {
        if (null == this.factory) {
            this.factory = new GenericIndexedRecordConverter();
            this.factory.setSchema(((IndexedRecord)datum).getSchema());
        }
        return this.factory;
    }
}

