/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.config.jdbc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.talend.components.common.config.jdbc.Dbms;
import org.talend.components.common.config.jdbc.DbmsType;
import org.talend.components.common.config.jdbc.MappingType;
import org.talend.components.common.config.jdbc.TalendType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MappingFileLoader {
    public List<Dbms> load(String path) {
        return this.load(new File(path));
    }

    public List<Dbms> load(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder analyser = documentBuilderFactory.newDocumentBuilder();
            Document document = analyser.parse(file);
            NodeList dbmsNodes = document.getElementsByTagName("dbms");
            return this.constructAllDbms(dbmsNodes);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<Dbms> constructAllDbms(NodeList dbmsNodes) {
        ArrayList<Dbms> dbmsList = new ArrayList<Dbms>();
        for (int i = 0; i < dbmsNodes.getLength(); ++i) {
            Dbms dbms = this.constructDbms((Element)dbmsNodes.item(i));
            dbmsList.add(dbms);
        }
        return dbmsList;
    }

    private Dbms constructDbms(Element dbmsNode) {
        String productName = dbmsNode.getAttribute("product");
        String id = dbmsNode.getAttribute("id");
        String label = dbmsNode.getAttribute("label");
        boolean isDefault = Boolean.parseBoolean(dbmsNode.getAttribute("default"));
        Dbms dbms = new Dbms(id, productName, label, isDefault);
        Element dbTypesNode = this.getChildElement(dbmsNode, "dbTypes");
        NodeList dbTypes = dbTypesNode.getElementsByTagName("dbType");
        for (int i = 0; i < dbTypes.getLength(); ++i) {
            this.constructDbmsType((Element)dbTypes.item(i), dbms);
        }
        Element javaLanguageNode = this.findJavaLanguage(dbmsNode.getElementsByTagName("language"));
        Element talendToDbmsTypes = this.getChildElement(javaLanguageNode, "talendToDbTypes");
        List<Element> talendMappings = this.getChildren(talendToDbmsTypes);
        for (Element el : talendMappings) {
            this.constructTalendMapping(el, dbms);
        }
        Element dbTypesToTalend = this.getChildElement(javaLanguageNode, "dbToTalendTypes");
        List<Element> dbMappings = this.getChildren(dbTypesToTalend);
        for (Element el : dbMappings) {
            this.constructDbMapping(el, dbms);
        }
        return dbms;
    }

    private void constructDbMapping(Element dbMapping, Dbms dbms) {
        String dbTypeName = dbMapping.getAttribute("type");
        DbmsType dbType = dbms.getDbmsType(dbTypeName);
        List<Element> correspondingTalendTypes = this.getChildren(dbMapping);
        HashSet<TalendType> targetTypes = new HashSet<TalendType>();
        TalendType defaultType = null;
        for (Element talendTypeNode : correspondingTalendTypes) {
            String talendTypeName = talendTypeNode.getAttribute("type");
            targetTypes.add(TalendType.get(talendTypeName));
            String defaultAttrValue = talendTypeNode.getAttribute("default");
            boolean isDefault = defaultAttrValue.isEmpty() ? false : Boolean.parseBoolean(defaultAttrValue);
            if (!isDefault) continue;
            defaultType = TalendType.get(talendTypeName);
        }
        MappingType<DbmsType, Object> typeMapping = new MappingType<DbmsType, Object>(dbType, defaultType, (Set<Object>)targetTypes);
        dbms.addDbMapping(dbTypeName, typeMapping);
    }

    private Element findJavaLanguage(NodeList languagesNodeList) {
        for (int i = 0; i < languagesNodeList.getLength(); ++i) {
            Element languageNode = (Element)languagesNodeList.item(0);
            if (!languageNode.getAttribute("name").equals("java")) continue;
            return languageNode;
        }
        return null;
    }

    private void constructDbmsType(Element dbTypeNode, Dbms dbms) {
        String typeName = dbTypeNode.getAttribute("type");
        boolean isDefault = false;
        String isDefaultAttribute = dbTypeNode.getAttribute("default");
        if (!isDefaultAttribute.isEmpty()) {
            isDefault = Boolean.parseBoolean(isDefaultAttribute);
        }
        int defaultLength = -1;
        String defaultLengthAttribute = dbTypeNode.getAttribute("defaultLength");
        if (!defaultLengthAttribute.isEmpty()) {
            defaultLength = Integer.parseInt(defaultLengthAttribute);
        }
        int defaultPrecision = -1;
        String defaultPrecisionAttribute = dbTypeNode.getAttribute("defaultPrecision");
        if (!defaultPrecisionAttribute.isEmpty()) {
            defaultPrecision = Integer.parseInt(defaultPrecisionAttribute);
        }
        boolean ignoreLen = false;
        String ignoreLenAttribute = dbTypeNode.getAttribute("ignoreLen");
        if (!ignoreLenAttribute.isEmpty()) {
            ignoreLen = Boolean.parseBoolean(ignoreLenAttribute);
        }
        boolean ignorePre = false;
        String ignorePreAttribute = dbTypeNode.getAttribute("ignorePre");
        if (!ignorePreAttribute.isEmpty()) {
            ignorePre = Boolean.parseBoolean(ignorePreAttribute);
        }
        boolean preBeforeLen = false;
        String preBeforeLenAttribute = dbTypeNode.getAttribute("preBeforeLen");
        if (!preBeforeLenAttribute.isEmpty()) {
            preBeforeLen = Boolean.parseBoolean(preBeforeLenAttribute);
        }
        DbmsType dbType = new DbmsType(typeName, isDefault, defaultLength, defaultPrecision, ignoreLen, ignorePre, preBeforeLen);
        dbms.addType(typeName, dbType);
    }

    private void constructTalendMapping(Element talendMapping, Dbms dbms) {
        String talendTypeName = talendMapping.getAttribute("type");
        TalendType talendType = TalendType.get(talendTypeName);
        List<Element> correspondingDbmsTypes = this.getChildren(talendMapping);
        HashSet<DbmsType> targetTypes = new HashSet<DbmsType>();
        DbmsType defaultType = null;
        for (Element dbTypeNode : correspondingDbmsTypes) {
            String dbType = dbTypeNode.getAttribute("type");
            targetTypes.add(dbms.getDbmsType(dbType));
            String defaultAttrValue = dbTypeNode.getAttribute("default");
            boolean isDefault = defaultAttrValue.isEmpty() ? false : Boolean.parseBoolean(defaultAttrValue);
            if (!isDefault) continue;
            defaultType = dbms.getDbmsType(dbType);
        }
        MappingType<TalendType, Object> typeMapping = new MappingType<TalendType, Object>(talendType, defaultType, (Set<Object>)targetTypes);
        dbms.addTalendMapping(talendTypeName, typeMapping);
    }

    private Element getChildElement(Element parent, String tagName) {
        return (Element)parent.getElementsByTagName(tagName).item(0);
    }

    private List<Element> getChildren(Node parentNode) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Node childNode = parentNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            list.add((Element)childNode);
        }
        return list;
    }
}

