/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.config.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.talend.components.common.config.jdbc.DbmsType;
import org.talend.components.common.config.jdbc.MappingType;
import org.talend.components.common.config.jdbc.TalendType;

public class Dbms {
    private final String id;
    private final String product;
    private final String label;
    private final boolean isDefaultDbms;
    private final Map<String, DbmsType> types = new HashMap<String, DbmsType>();
    private final Map<String, MappingType<TalendType, DbmsType>> talendToDbmsMapping = new HashMap<String, MappingType<TalendType, DbmsType>>();
    private final Map<String, MappingType<DbmsType, TalendType>> dbmsToTalendMapping = new HashMap<String, MappingType<DbmsType, TalendType>>();
    private String defaultDbmsType;

    public Dbms(String id, String product, String label, boolean isDefault) {
        this.id = id;
        this.product = product;
        this.label = label;
        this.isDefaultDbms = isDefault;
    }

    public List<String> getDbmsTypes() {
        return new ArrayList<String>(this.types.keySet());
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getProduct() {
        return this.product;
    }

    public String getDefaultDbmsType() {
        return this.defaultDbmsType;
    }

    public DbmsType getDbmsType(String dbmsTypeName) {
        return this.types.get(dbmsTypeName);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Dbms[");
        buffer.append("product = ").append(this.product);
        buffer.append(", id = ").append(this.id);
        buffer.append(", label = ").append(this.label);
        buffer.append(", defaultDbmsType = ").append(this.defaultDbmsType);
        buffer.append(", dbmsTypes = ").append(this.getDbmsTypes());
        buffer.append("]");
        return buffer.toString();
    }

    void addType(String typeName, DbmsType type) {
        this.types.put(typeName, type);
    }

    public MappingType<TalendType, DbmsType> getTalendMapping(String talendTypeName) {
        return this.talendToDbmsMapping.get(talendTypeName);
    }

    public MappingType<DbmsType, TalendType> getDbmsMapping(String dbmsTypeName) {
        return this.dbmsToTalendMapping.get(dbmsTypeName);
    }

    public Set<TalendType> getAdvisedTalendTypes(String dbmsTypeName) {
        return this.getDbmsMapping(dbmsTypeName).getAdvisedTypes();
    }

    public Set<DbmsType> getAdvisedDbmsTypes(String talendTypeName) {
        return this.getTalendMapping(talendTypeName).getAdvisedTypes();
    }

    public boolean isAdvisedTalendType(String talendTypeName, String dbmsTypeName) {
        TalendType talendType = TalendType.get(talendTypeName);
        return this.getAdvisedTalendTypes(dbmsTypeName).contains((Object)talendType);
    }

    public boolean isAdvisedDbmsType(String dbmsTypeName, String talendTypeName) {
        DbmsType dbmsType = this.getDbmsType(dbmsTypeName);
        return this.getAdvisedDbmsTypes(talendTypeName).contains(dbmsType);
    }

    void addTalendMapping(String sourceTypeName, MappingType<TalendType, DbmsType> mapping) {
        this.talendToDbmsMapping.put(sourceTypeName, mapping);
    }

    void addDbMapping(String sourceTypeName, MappingType<DbmsType, TalendType> mapping) {
        this.dbmsToTalendMapping.put(sourceTypeName, mapping);
    }

    boolean isDefaultDbms() {
        return this.isDefaultDbms;
    }
}

