/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.component.runtime;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.talend.components.common.avro.RootSchemaUtils;

public final class RootRecordUtils {
    private RootRecordUtils() {
    }

    public static IndexedRecord createRootRecord(Schema mainSchema, Schema outOfBandSchema) {
        if (mainSchema == null || outOfBandSchema == null) {
            throw new IllegalArgumentException("Input schemas should be not null");
        }
        Schema rootSchema = RootSchemaUtils.createRootSchema(mainSchema, outOfBandSchema);
        return RootRecordUtils.createRootRecord(rootSchema);
    }

    public static IndexedRecord createRootRecord(Schema rootSchema) {
        if (!RootSchemaUtils.isRootSchema(rootSchema)) {
            throw new IllegalArgumentException("Input schema should be Root schema");
        }
        GenericData.Record rootRecord = new GenericData.Record(rootSchema);
        return rootRecord;
    }

    public static IndexedRecord createRootRecord(Schema rootSchema, IndexedRecord dataRecord, IndexedRecord outOfBandRecord) {
        IndexedRecord rootRecord = RootRecordUtils.createRootRecord(rootSchema);
        rootRecord.put(0, (Object)dataRecord);
        rootRecord.put(1, (Object)outOfBandRecord);
        return rootRecord;
    }

    public static boolean isRootRecord(Object data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof IndexedRecord)) {
            return false;
        }
        IndexedRecord record = (IndexedRecord)data;
        Schema recordSchema = record.getSchema();
        boolean result = RootSchemaUtils.isRootSchema(recordSchema);
        return result;
    }
}

