/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.avro;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.codehaus.jackson.JsonNode;
import org.talend.components.api.exception.ComponentException;
import org.talend.components.common.avro.JDBCAvroRegistryInfluencer;
import org.talend.components.common.avro.JDBCTableMetadata;
import org.talend.daikon.avro.AvroNamesValidationHelper;
import org.talend.daikon.avro.AvroRegistry;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.NameUtil;
import org.talend.daikon.avro.converter.AvroConverter;
import org.talend.daikon.avro.converter.IndexedRecordConverter;
import org.talend.daikon.java8.SerializableFunction;

public class JDBCAvroRegistry
extends AvroRegistry {
    private static final JDBCAvroRegistry sInstance = new JDBCAvroRegistry();

    public static JDBCAvroRegistry get() {
        return sInstance;
    }

    protected JDBCAvroRegistry() {
        this.registerSchemaInferrer(JDBCTableMetadata.class, (SerializableFunction)new SerializableFunction<JDBCTableMetadata, Schema>(){
            private static final long serialVersionUID = 1L;

            public Schema apply(JDBCTableMetadata t) {
                try {
                    return JDBCAvroRegistry.this.inferSchemaResultSet(t);
                }
                catch (SQLException e) {
                    throw new ComponentException((Throwable)e);
                }
            }
        });
        this.registerSchemaInferrer(ResultSetMetaData.class, (SerializableFunction)new SerializableFunction<ResultSetMetaData, Schema>(){
            private static final long serialVersionUID = 1L;

            public Schema apply(ResultSetMetaData t) {
                try {
                    return JDBCAvroRegistry.this.inferSchemaResultSetMetaData(t);
                }
                catch (SQLException e) {
                    throw new ComponentException((Throwable)e);
                }
            }
        });
    }

    protected Schema inferSchemaResultSetMetaData(ResultSetMetaData metadata) throws SQLException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        int count = metadata.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            int size = metadata.getPrecision(i);
            int scale = metadata.getScale(i);
            boolean nullable = 1 == metadata.isNullable(i);
            int dbtype = metadata.getColumnType(i);
            String fieldName = metadata.getColumnLabel(i);
            String dbColumnName = metadata.getColumnName(i);
            boolean isKey = false;
            Schema.Field field = this.sqlType2Avro(size, scale, dbtype, nullable, fieldName, dbColumnName, null, isKey);
            fields.add(field);
        }
        return Schema.createRecord((String)"DYNAMIC", null, null, (boolean)false, fields);
    }

    protected Schema inferSchemaResultSet(JDBCTableMetadata tableMetadata) throws SQLException {
        DatabaseMetaData databaseMetdata = tableMetadata.getDatabaseMetaData();
        Set<String> keys = this.getPrimaryKeys(databaseMetdata, tableMetadata.getCatalog(), tableMetadata.getDbSchema(), tableMetadata.getTablename());
        try (ResultSet metadata = databaseMetdata.getColumns(tableMetadata.getCatalog(), tableMetadata.getDbSchema(), tableMetadata.getTablename(), null);){
            if (!metadata.next()) {
                Schema schema = null;
                return schema;
            }
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            String tablename = metadata.getString("TABLE_NAME");
            do {
                int size = metadata.getInt("COLUMN_SIZE");
                int scale = metadata.getInt("DECIMAL_DIGITS");
                int dbtype = metadata.getInt("DATA_TYPE");
                boolean nullable = 1 == metadata.getInt("NULLABLE");
                String columnName = metadata.getString("COLUMN_NAME");
                boolean isKey = keys.contains(columnName);
                String defaultValue = metadata.getString("COLUMN_DEF");
                Schema.Field field = this.sqlType2Avro(size, scale, dbtype, nullable, columnName, columnName, defaultValue, isKey);
                fields.add(field);
            } while (metadata.next());
            Schema schema = Schema.createRecord((String)AvroNamesValidationHelper.getAvroCompatibleName((String)NameUtil.correct((String)tablename, (int)0, Collections.emptySet())), null, null, (boolean)false, fields);
            return schema;
        }
    }

    private Set<String> getPrimaryKeys(DatabaseMetaData databaseMetdata, String catalogName, String schemaName, String tableName) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = databaseMetdata.getPrimaryKeys(catalogName, schemaName, tableName);){
            if (resultSet != null) {
                while (resultSet.next()) {
                    result.add(resultSet.getString("COLUMN_NAME"));
                }
            }
        }
        return result;
    }

    protected Schema.Field sqlType2Avro(int size, int scale, int dbtype, boolean nullable, String name, String dbColumnName, Object defaultValue, boolean isKey) {
        Schema.Field field = null;
        Schema schema = null;
        switch (dbtype) {
            case 12: {
                schema = AvroUtils._string();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.length", (Object)size);
                break;
            }
            case 4: {
                schema = AvroUtils._int();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                break;
            }
            case 3: {
                schema = AvroUtils._decimal();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                field.addProp("talend.field.scale", (Object)scale);
                break;
            }
            case -5: {
                schema = AvroUtils._long();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                break;
            }
            case 2: {
                schema = AvroUtils._decimal();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                field.addProp("talend.field.scale", (Object)scale);
                break;
            }
            case -6: {
                schema = AvroUtils._byte();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                break;
            }
            case 8: {
                schema = AvroUtils._double();
                field = this.wrap(nullable, schema, name);
                break;
            }
            case 6: {
                schema = AvroUtils._float();
                field = this.wrap(nullable, schema, name);
                break;
            }
            case 91: {
                schema = AvroUtils._date();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.pattern", "yyyy-MM-dd");
                break;
            }
            case 92: {
                schema = AvroUtils._date();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.pattern", "HH:mm:ss");
                break;
            }
            case 93: {
                schema = AvroUtils._date();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.pattern", "yyyy-MM-dd HH:mm:ss.SSS");
                break;
            }
            case 16: {
                schema = AvroUtils._boolean();
                field = this.wrap(nullable, schema, name);
                break;
            }
            case 7: {
                schema = AvroUtils._float();
                field = this.wrap(nullable, schema, name);
                break;
            }
            case 5: {
                schema = AvroUtils._short();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.precision", (Object)size);
                break;
            }
            case -1: {
                schema = AvroUtils._string();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.length", (Object)size);
                break;
            }
            case 1: {
                schema = AvroUtils._string();
                field = this.wrap(nullable, schema, name);
                field.addProp("talend.field.length", (Object)size);
                break;
            }
            default: {
                schema = AvroUtils._string();
                field = this.wrap(nullable, schema, name);
            }
        }
        field.addProp("talend.field.dbType", (Object)dbtype);
        field.addProp("talend.field.dbColumnName", dbColumnName);
        if (defaultValue != null) {
            field.addProp("talend.field.default", defaultValue);
        }
        if (isKey) {
            field.addProp("talend.field.isKey", "true");
        }
        return field;
    }

    protected Schema.Field wrap(boolean nullable, Schema base, String name) {
        Schema schema = nullable ? (Schema)SchemaBuilder.builder().nullable().type(base) : base;
        return new Schema.Field(name, schema, null, (JsonNode)null);
    }

    public JDBCConverter getConverter(Schema.Field f, final int index) {
        Schema basicSchema = AvroUtils.unwrapIfNullable((Schema)f.schema());
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._string())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    boolean trim = this.isTrim() || this.isTrim(index);
                    try {
                        String result = value.getString(index);
                        if (trim && result != null) {
                            return result.trim();
                        }
                        return result;
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._int())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getInt(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._date())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    Date date = null;
                    try {
                        date = value.getTimestamp(index);
                    }
                    catch (Exception e1) {
                        try {
                            date = value.getDate(index);
                        }
                        catch (SQLException e2) {
                            throw new ComponentException((Throwable)e2);
                        }
                    }
                    if (date == null) {
                        return null;
                    }
                    return date.getTime();
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._decimal())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    try {
                        return value.getBigDecimal(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._long())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getLong(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._double())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getDouble(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._float())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return Float.valueOf(value.getFloat(index));
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._boolean())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getBoolean(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._short())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getShort(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._character())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    boolean trim = this.isTrim() || this.isTrim(index);
                    try {
                        String result = value.getString(index);
                        if (trim && result != null) {
                            return result.trim();
                        }
                        if (result == null || result.isEmpty()) {
                            return null;
                        }
                        return Character.valueOf(result.charAt(0));
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._byte())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getByte(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._bytes())) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    try {
                        byte[] result = value.getBytes(index);
                        if (value.wasNull()) {
                            return null;
                        }
                        return result;
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (JDBCAvroRegistry.isObject(basicSchema)) {
            return new JDBCConverter(){

                public Object convertToAvro(ResultSet value) {
                    try {
                        return value.getObject(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        return new JDBCConverter(){

            public Object convertToAvro(ResultSet value) {
                boolean trim = this.isTrim() || this.isTrim(index);
                try {
                    String result = value.getString(index);
                    if (trim && result != null) {
                        return result.trim();
                    }
                    return result;
                }
                catch (SQLException e) {
                    throw new ComponentException((Throwable)e);
                }
            }
        };
    }

    public JDBCConverter getConverter(Schema.Field f) {
        return this.getConverter(f, f.pos() + 1);
    }

    public JDBCSPConverter getSPConverter(Schema.Field f, final int index) {
        Schema basicSchema = AvroUtils.unwrapIfNullable((Schema)f.schema());
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._string())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        String result = value.getString(index);
                        return result;
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._int())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getInt(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._date())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    Date date = null;
                    try {
                        date = value.getTimestamp(index);
                    }
                    catch (Exception e1) {
                        try {
                            date = value.getDate(index);
                        }
                        catch (SQLException e2) {
                            throw new ComponentException((Throwable)e2);
                        }
                    }
                    if (date == null) {
                        return null;
                    }
                    return date.getTime();
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._decimal())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        return value.getBigDecimal(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._long())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getLong(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._double())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getDouble(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._float())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return Float.valueOf(value.getFloat(index));
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._boolean())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getBoolean(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._short())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getShort(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._character())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        String result = value.getString(index);
                        if (result == null || result.isEmpty()) {
                            return null;
                        }
                        return Character.valueOf(result.charAt(0));
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._byte())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        if (value.getObject(index) == null) {
                            return null;
                        }
                        return value.getByte(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (AvroUtils.isSameType((Schema)basicSchema, (Schema)AvroUtils._bytes())) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        byte[] result = value.getBytes(index);
                        if (value.wasNull()) {
                            return null;
                        }
                        return result;
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        if (JDBCAvroRegistry.isObject(basicSchema)) {
            return new JDBCSPConverter(){

                public Object convertToAvro(CallableStatement value) {
                    try {
                        return value.getObject(index);
                    }
                    catch (SQLException e) {
                        throw new ComponentException((Throwable)e);
                    }
                }
            };
        }
        return new JDBCSPConverter(){

            public Object convertToAvro(CallableStatement value) {
                try {
                    String result = value.getString(index);
                    return result;
                }
                catch (SQLException e) {
                    throw new ComponentException((Throwable)e);
                }
            }
        };
    }

    public static boolean isObject(Schema schema) {
        if (schema == null) {
            return false;
        }
        return schema.getType() == Schema.Type.STRING && schema.getProp("java-class") != null;
    }

    public abstract class JDBCSPConverter
    implements AvroConverter<CallableStatement, Object> {
        protected JDBCAvroRegistryInfluencer influencer;

        public Schema getSchema() {
            return null;
        }

        public Class<CallableStatement> getDatumClass() {
            return null;
        }

        public CallableStatement convertToDatum(Object value) {
            throw new IndexedRecordConverter.UnmodifiableAdapterException();
        }
    }

    public abstract class JDBCConverter
    implements AvroConverter<ResultSet, Object> {
        protected JDBCAvroRegistryInfluencer influencer;

        public Schema getSchema() {
            return null;
        }

        public Class<ResultSet> getDatumClass() {
            return null;
        }

        public ResultSet convertToDatum(Object value) {
            throw new IndexedRecordConverter.UnmodifiableAdapterException();
        }

        protected boolean isTrim() {
            if (this.influencer != null) {
                return this.influencer.trim();
            }
            return false;
        }

        protected boolean isTrim(int index) {
            if (this.influencer != null) {
                return this.influencer.isTrim(index);
            }
            return false;
        }

        public void setInfluencer(JDBCAvroRegistryInfluencer influencer) {
            this.influencer = influencer;
        }
    }
}

