/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common;

import java.util.EnumSet;
import org.talend.components.api.properties.ComponentBasePropertiesImpl;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;

public class UserPasswordProperties
extends ComponentBasePropertiesImpl {
    public Property<Boolean> useAuth = PropertyFactory.newBoolean((String)"useAuth", (Boolean)false);
    public Property<String> userId = PropertyFactory.newProperty((String)"userId");
    public Property<String> password = PropertyFactory.newProperty((String)"password").setFlags(EnumSet.of(Property.Flags.ENCRYPT, Property.Flags.SUPPRESS_LOGGING));
    private boolean needSwitch = false;

    public UserPasswordProperties(String name) {
        super(name);
    }

    public UserPasswordProperties(String name, Boolean withSwitch) {
        super(name);
        this.needSwitch = withSwitch;
    }

    public void setupProperties() {
        super.setupProperties();
        if (this.needSwitch) {
            this.useAuth.setRequired();
        } else {
            this.userId.setRequired();
            this.password.setRequired();
        }
    }

    public void setupLayout() {
        super.setupLayout();
        Form form = Form.create((Properties)this, (String)"Main");
        if (this.needSwitch) {
            form.addRow(this.useAuth);
        }
        form.addRow(this.userId);
        form.addRow(Widget.widget(this.password).setWidgetType("widget.type.hidden.text"));
    }

    public void afterUseAuth() {
        this.refreshLayout(this.getForm("Main"));
    }

    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        if (form.getName().equals("Main") && this.needSwitch) {
            form.getWidget(this.userId).setVisible(this.useAuth);
            form.getWidget(this.password).setVisible(this.useAuth);
        }
    }
}

