/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JAssignment;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Arrays;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TextIndex;
import org.jpmml.evaluator.TextUtil;
import org.jpmml.evaluator.TokenizedString;
import org.jpmml.translator.FieldInfo;
import org.jpmml.translator.FunctionInvocation;
import org.jpmml.translator.StringRef;
import org.jpmml.translator.TranslationContext;

public class TextIndexUtil {
    private TextIndexUtil() {
    }

    public static TextIndex toLocalTextIndex(TextIndex textIndex, String name) {
        String wordRE = textIndex.getWordRE();
        String wordSeparatorCharacterRE = textIndex.getWordSeparatorCharacterRE();
        if (wordRE != null) {
            wordSeparatorCharacterRE = null;
        }
        TextIndex localTextIndex = new TextIndex(name, null).setLocalTermWeights(textIndex.getLocalTermWeights()).setCaseSensitive(Boolean.valueOf(textIndex.isCaseSensitive())).setMaxLevenshteinDistance(textIndex.getMaxLevenshteinDistance()).setCountHits(textIndex.getCountHits()).setWordRE(wordRE).setWordSeparatorCharacterRE(wordSeparatorCharacterRE).setTokenize(Boolean.valueOf(textIndex.isTokenize()));
        if (textIndex.hasTextIndexNormalizations()) {
            localTextIndex.getTextIndexNormalizations().addAll(textIndex.getTextIndexNormalizations());
        }
        return localTextIndex;
    }

    public static JExpression computeTermFrequencyTable(JVar assignmentTargetVar, TextIndex textIndex, JExpression textIndexExpr, JExpression vocabularyExpr, int maxLength, TranslationContext context) {
        FieldInfo textFieldInfo = new FieldInfo((Field<?>)new DerivedField(textIndex.requireTextField(), OpType.CATEGORICAL, DataType.STRING, null));
        StringRef textRef = (StringRef)context.ensureOperable(textFieldInfo, method -> true);
        JVar textVar = (JVar)textRef.getExpression();
        if (textIndex.hasTextIndexNormalizations()) {
            JInvocation textNormalizationInvocation = context.staticInvoke(TextUtil.class, "normalize", textIndexExpr, textVar);
            context.add((JStatement)((JAssignment)textVar.assign((JExpression)textNormalizationInvocation)));
        }
        JInvocation textTokenizationInvocation = context.staticInvoke(TextUtil.class, "tokenize", textIndexExpr, textVar);
        JVar textTokensVar = context.declare((JType)context.ref(TokenizedString.class), textVar.name() + "Tokens", (JExpression)textTokenizationInvocation);
        JInvocation termFrequencyTableInvocation = context.staticInvoke(TextUtil.class, "termFrequencyTable", textIndexExpr, textTokensVar, vocabularyExpr, maxLength);
        if (assignmentTargetVar != null) {
            context.add((JStatement)((JAssignment)assignmentTargetVar.assign((JExpression)termFrequencyTableInvocation)));
            return termFrequencyTableInvocation;
        }
        JVar termFrequencyTableVar = context.declare((JType)context.ref(Map.class).narrow(Arrays.asList(context.ref(TokenizedString.class), context.ref(Integer.class))), textVar.name() + "FrequencyTable", (JExpression)termFrequencyTableInvocation);
        return termFrequencyTableVar;
    }

    public static FunctionInvocation.Tf asTf(FunctionInvocation functionInvocation) {
        if (functionInvocation instanceof FunctionInvocation.Tf) {
            FunctionInvocation.Tf tf = (FunctionInvocation.Tf)functionInvocation;
            return tf;
        }
        if (functionInvocation instanceof FunctionInvocation.TfIdf) {
            FunctionInvocation.TfIdf tfIdf = (FunctionInvocation.TfIdf)functionInvocation;
            FunctionInvocation.Tf tf = tfIdf.getTf();
            return tf;
        }
        throw new IllegalArgumentException();
    }

    public static FunctionInvocation.TfIdf asTfIdf(FunctionInvocation functionInvocation) {
        if (functionInvocation instanceof FunctionInvocation.Tf) {
            final FunctionInvocation.Tf tf = (FunctionInvocation.Tf)functionInvocation;
            return new FunctionInvocation.TfIdf(){

                @Override
                public FunctionInvocation.Tf getTf() {
                    return tf;
                }

                @Override
                public Number getWeight() {
                    return 1;
                }
            };
        }
        if (functionInvocation instanceof FunctionInvocation.TfIdf) {
            FunctionInvocation.TfIdf tfIdf = (FunctionInvocation.TfIdf)functionInvocation;
            return tfIdf;
        }
        throw new IllegalArgumentException();
    }
}

