/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.util;

import cz.drg.clasificator.util.OutputHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilesCache {
    private static final List<String> FILE_CACHE = Collections.synchronizedList(new ArrayList());

    public static void addCreatedFile(String filepath) {
        FILE_CACHE.add(filepath);
    }

    public static void freeRemovedFile(String filepath) {
        FILE_CACHE.remove(filepath);
    }

    public static void removeAllCachedFiles() {
        FILE_CACHE.forEach(file -> {
            try {
                Files.deleteIfExists(Paths.get(file, new String[0]));
            }
            catch (IOException ex) {
                OutputHelper.dualLog("Failed to delete cached file [" + file + "] due to '" + ex.getMessage() + "'.");
            }
        });
        FILE_CACHE.clear();
    }
}

