/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.setting;

import cz.drg.clasificator.setting.ProgramSettings;
import cz.drg.clasificator.setting.program.Program;
import cz.drg.clasificator.util.JacksonUtil;
import cz.drg.clasificator.util.OutputHelper;
import java.io.File;
import java.io.IOException;

public class Settings {
    private static final String DEFAULT_PROGRAM_SETTING_DIR = "settings/";
    private static final String DEFAULT_PROGRAM_SETTING = "settings/programSettings.xml";
    private static final String DEFAULT_PROGRAM_TEST_SETTING_DIR = "src/test/data/";
    private static final String DEFAULT_PROGRAM_TEST_SETTING = "src/test/data/programTestSettings.xml";
    private static ProgramSettings programSettings;

    public static void loadSettings() {
        Settings.loadProgramSetting(DEFAULT_PROGRAM_SETTING);
    }

    public static void loadSettings(String settingPath) {
        File setting = new File(settingPath);
        if (!setting.exists()) {
            OutputHelper.dualLog(String.format("Program settings at '%s' doesnt exist or cannot be accessed. \nLoading default setting file.", settingPath));
            settingPath = DEFAULT_PROGRAM_SETTING;
        }
        Settings.loadProgramSetting(settingPath);
    }

    public static void loadTestSettings() {
        Settings.loadProgramSetting(DEFAULT_PROGRAM_TEST_SETTING);
    }

    private static void loadProgramSetting(String settingPath) {
        File setting = new File(settingPath);
        if (!setting.exists()) {
            OutputHelper.dualLog(String.format("Program settings at '%s' doesnt exist or cannot be accessed. \nLoading default setting file.", settingPath));
            System.exit(0);
        }
        Program programSettingXML = null;
        try {
            programSettingXML = (Program)JacksonUtil.mapper().readValue(setting, Program.class);
        }
        catch (IOException ex) {
            OutputHelper.dualLog(String.format("Program settings at '%s' has illegal structure.", settingPath));
            System.exit(-1);
        }
        programSettings = new ProgramSettings(programSettingXML);
    }

    public static ProgramSettings getProgramSettings() {
        if (programSettings == null) {
            throw new IllegalStateException("Cannot fetch the program settings before loading it first!");
        }
        return programSettings;
    }
}

