/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.readers;

import cz.drg.clasificator.readers.InputReader;
import cz.drg.clasificator.util.HeaderList;
import cz.drg.clasificator.util.HeaderListReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;

public abstract class BaseReader
implements InputReader,
HeaderListReader {
    private String DELIMITER;
    private String ROW_SPLIT_REGEX;
    private final ZipFile pmmlInput;
    private Map<String, Integer> headers;
    private List<List<String>> columns;
    private int numberOfLines = 0;
    private boolean alreadyReadFrom = false;

    public BaseReader(ZipFile pmmlInput, String delimiter) {
        this.pmmlInput = pmmlInput;
        this.DELIMITER = delimiter;
        this.ROW_SPLIT_REGEX = this.DELIMITER + "(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    }

    protected void init() {
        this.headers = new HashMap<String, Integer>();
        this.columns = new ArrayList<List<String>>();
    }

    protected abstract List<String> getData();

    protected void readSource(List<String> lines) {
        this.columns.clear();
        this.numberOfLines = lines.size();
        if (!this.alreadyReadFrom) {
            this.numberOfLines = lines.size() - 1;
        }
        block0: for (int rowIndex = 0; rowIndex < lines.size(); ++rowIndex) {
            String[] rowColumns = lines.get(rowIndex).split(this.ROW_SPLIT_REGEX, -1);
            for (int columnIndex = 0; columnIndex < rowColumns.length; ++columnIndex) {
                String column = rowColumns[columnIndex].replaceAll("\"", "");
                if (rowIndex == 0 && !this.alreadyReadFrom) {
                    this.headers.put(column, columnIndex);
                    continue;
                }
                if (rowColumns.length != this.headers.size()) {
                    --this.numberOfLines;
                    continue block0;
                }
                if (this.columns.size() <= columnIndex) {
                    this.columns.add(new ArrayList());
                }
                this.columns.get(columnIndex).add(column);
            }
        }
        this.alreadyReadFrom = true;
    }

    @Override
    public Map<String, Integer> getHeadersWithIndexes() {
        return this.headers;
    }

    @Override
    public List<List<String>> getColumnLists() {
        return this.columns;
    }

    @Override
    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    @Override
    public ZipFile readPmmlInput() {
        return this.pmmlInput;
    }

    @Override
    public HeaderList readNextEntryBatch() {
        this.readSource(this.getData());
        return new HeaderList(this);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void close() {
    }
}

