/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.args;

import com.google.common.collect.Lists;
import cz.drg.clasificator.CZDRGClasificator;
import cz.drg.clasificator.args.ProgramExecutor;
import cz.drg.clasificator.args.argevaluation.ArgEvaluatorFactory;
import cz.drg.clasificator.args.argevaluation.Evaluator;
import cz.drg.clasificator.args.argevaluation.EvaluatorFactory;
import cz.drg.clasificator.exception.ShutdownException;
import cz.drg.clasificator.readers.BaseReader;
import cz.drg.clasificator.readers.CsvReader;
import cz.drg.clasificator.readers.InputReader;
import cz.drg.clasificator.readers.SystemInReader;
import cz.drg.clasificator.setting.Settings;
import cz.drg.clasificator.writers.CsvWriter;
import cz.drg.clasificator.writers.OutputWriter;
import java.io.IOException;
import java.util.ArrayList;

public class CZDRGExecutor
implements ProgramExecutor {
    private InputReader reader;
    private OutputWriter writer;
    private EvaluatorFactory evalFactory;
    private Evaluator currentEvaluator;

    @Override
    public void execute(String[] args) {
        this.checkForConfigFileChange(args);
        this.evalFactory = new ArgEvaluatorFactory();
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (this.currentEvaluator != null) {
                    this.currentEvaluator.evaluate(this);
                }
                this.currentEvaluator = this.evalFactory.getEvaluator(arg.substring(1));
                continue;
            }
            if (this.currentEvaluator == null) {
                this.stopExecution(String.format("Illegal argument order at '%s' argument. Received arguments [%s].", arg, String.join((CharSequence)";", args)));
                continue;
            }
            this.currentEvaluator.addParameter(arg);
        }
        if (this.currentEvaluator != null) {
            this.currentEvaluator.evaluate(this);
        }
        if (this.reader == null) {
            this.setDefaultReader();
        }
        if (this.writer == null) {
            this.setDefaultWriter();
        }
        this.reader.initialize();
        this.startEvaluation(this.reader, this.writer);
    }

    public void startEvaluation(InputReader reader, OutputWriter writer) {
        new CZDRGClasificator().startEvaluation(reader, writer);
    }

    private void setDefaultReader() {
        try {
            BaseReader reader = System.in.available() == 0 ? new CsvReader() : new SystemInReader();
            this.setReader(reader);
        }
        catch (IOException ex) {
            throw new ShutdownException("Could not set default reader/writer.");
        }
    }

    private void checkForConfigFileChange(String[] args) {
        ArrayList argsList = Lists.newArrayList((Object[])args);
        int indexOf = argsList.indexOf("-configFile");
        if (indexOf == -1) {
            Settings.loadSettings();
            return;
        }
        String configFilePath = (String)argsList.get(indexOf + 1);
        Settings.loadSettings(configFilePath);
    }

    private void setDefaultWriter() {
        this.setWriter(new CsvWriter());
    }

    @Override
    public void setWriter(OutputWriter writer) {
        this.writer = writer;
    }

    @Override
    public void setReader(InputReader reader) {
        this.reader = reader;
    }

    @Override
    public void stopExecution(String message) {
        throw new ShutdownException(message);
    }
}

