/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.writer;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.component.runtime.WriteOperation;
import org.talend.components.api.component.runtime.WriterWithFeedback;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.common.avro.JDBCAvroRegistry;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.avro.JDBCSPIndexedRecordCreator;
import org.talend.components.jdbc.runtime.JDBCSPSink;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.daikon.avro.converter.IndexedRecordConverter;

public class JDBCSPWriter
implements WriterWithFeedback<Result, IndexedRecord, IndexedRecord> {
    private static final transient Logger LOG = LoggerFactory.getLogger(JDBCSPWriter.class);
    private WriteOperation<Result> writeOperation;
    private Connection conn;
    private JDBCSPSink sink;
    private AllSetting setting;
    private RuntimeContainer runtime;
    private Result result;
    private boolean useExistedConnection;
    private CallableStatement cs;
    private final List<IndexedRecord> successfulWrites = new ArrayList<IndexedRecord>();
    private final List<IndexedRecord> rejectedWrites = new ArrayList<IndexedRecord>();
    private Schema componentSchema;
    private Schema outputSchema;
    private JDBCSPIndexedRecordCreator indexedRecordCreator;
    private IndexedRecordConverter<Object, ? extends IndexedRecord> genericIndexedRecordConverter;

    public JDBCSPWriter(WriteOperation<Result> writeOperation, RuntimeContainer runtime) {
        this.writeOperation = writeOperation;
        this.runtime = runtime;
        this.sink = (JDBCSPSink)writeOperation.getSink();
        this.setting = this.sink.properties.getRuntimeSetting();
        this.useExistedConnection = this.setting.getReferencedComponentId() != null;
        this.result = new Result();
        this.componentSchema = CommonUtils.getMainSchemaFromInputConnector((ComponentProperties)((ComponentProperties)this.sink.properties));
        this.outputSchema = CommonUtils.getOutputSchema((ComponentProperties)((ComponentProperties)this.sink.properties));
    }

    public void open(String uId) throws IOException {
        try {
            this.conn = this.sink.getConnection(this.runtime);
            this.cs = this.conn.prepareCall(this.sink.getSPStatement(this.setting));
        }
        catch (ClassNotFoundException | SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public void write(Object datum) throws IOException {
        ++this.result.totalCount;
        this.cleanWrites();
        IndexedRecord inputRecord = (IndexedRecord)this.getGenericIndexedRecordConverter(datum).convertToAvro(datum);
        Schema inputSchema = inputRecord.getSchema();
        try {
            this.sink.fillParameters(this.cs, this.componentSchema, inputSchema, inputRecord, this.setting);
            this.cs.execute();
            if (this.indexedRecordCreator == null) {
                this.indexedRecordCreator = new JDBCSPIndexedRecordCreator();
                this.indexedRecordCreator.init(this.componentSchema, this.outputSchema, this.setting);
            }
            IndexedRecord outputRecord = this.indexedRecordCreator.createOutputIndexedRecord(this.cs, inputRecord);
            this.successfulWrites.add(outputRecord);
        }
        catch (Exception e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public Result close() throws IOException {
        this.closeStatementQuietly(this.cs);
        this.closeAtLast();
        return this.result;
    }

    private void closeAtLast() {
        if (this.useExistedConnection) {
            return;
        }
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public WriteOperation<Result> getWriteOperation() {
        return this.writeOperation;
    }

    private IndexedRecordConverter<Object, ? extends IndexedRecord> getGenericIndexedRecordConverter(Object datum) {
        if (null == this.genericIndexedRecordConverter) {
            this.genericIndexedRecordConverter = JDBCAvroRegistry.get().createIndexedRecordConverter(datum.getClass());
        }
        return this.genericIndexedRecordConverter;
    }

    private void closeStatementQuietly(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public List<IndexedRecord> getSuccessfulWrites() {
        return Collections.unmodifiableList(this.successfulWrites);
    }

    public List<IndexedRecord> getRejectedWrites() {
        return Collections.unmodifiableList(this.rejectedWrites);
    }

    public void cleanWrites() {
        this.successfulWrites.clear();
        this.rejectedWrites.clear();
    }
}

