/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.writer;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.component.runtime.WriteOperation;
import org.talend.components.api.component.runtime.WriterWithFeedback;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.common.avro.JDBCAvroRegistry;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.runtime.JDBCSink;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.runtime.setting.JDBCSQLBuilder;
import org.talend.components.jdbc.tjdbcoutput.TJDBCOutputProperties;
import org.talend.daikon.avro.converter.IndexedRecordConverter;

public abstract class JDBCOutputWriter
implements WriterWithFeedback<Result, IndexedRecord, IndexedRecord> {
    private static final transient Logger LOG = LoggerFactory.getLogger(JDBCOutputWriter.class);
    protected static final String QUERY_KEY = CommonUtils.getStudioNameFromProperty((String)"query");
    private WriteOperation<Result> writeOperation;
    protected Connection conn;
    protected JDBCSink sink;
    protected RuntimeSettingProvider properties;
    protected AllSetting setting;
    protected RuntimeContainer runtime;
    protected Result result;
    protected final List<IndexedRecord> successfulWrites = new ArrayList<IndexedRecord>();
    protected final List<IndexedRecord> rejectedWrites = new ArrayList<IndexedRecord>();
    protected int successCount;
    protected int rejectCount;
    protected boolean useBatch;
    protected int batchSize;
    protected int batchCount;
    protected int commitEvery;
    protected int commitCount;
    protected boolean useCommit;
    protected boolean useExistedConnection;
    protected boolean dieOnError;
    protected PreparedStatement statement;
    protected int insertCount;
    protected int updateCount;
    protected int deleteCount;
    protected List<JDBCSQLBuilder.Column> columnList;
    protected Schema componentSchema;
    protected Schema rejectSchema;
    private String bufferSizeKey4Parallelize;
    private IndexedRecordConverter<Object, ? extends IndexedRecord> factory;

    public JDBCOutputWriter(WriteOperation<Result> writeOperation, RuntimeContainer runtime) {
        this.writeOperation = writeOperation;
        this.runtime = runtime;
        if (this.runtime != null) {
            this.bufferSizeKey4Parallelize = "buffersSizeKey_" + runtime.getCurrentComponentId() + "_" + Thread.currentThread().getId();
        }
        this.sink = (JDBCSink)writeOperation.getSink();
        this.properties = this.sink.properties;
        this.setting = this.properties.getRuntimeSetting();
        this.useBatch = this.setting.getUseBatch();
        TJDBCOutputProperties.DataAction dataAction = this.setting.getDataAction();
        if (dataAction == TJDBCOutputProperties.DataAction.INSERT_OR_UPDATE || dataAction == TJDBCOutputProperties.DataAction.UPDATE_OR_INSERT) {
            this.useBatch = false;
        }
        if (this.useBatch) {
            this.batchSize = this.setting.getBatchSize();
        }
        boolean bl = this.useExistedConnection = this.setting.getReferencedComponentId() != null;
        if (!this.useExistedConnection && this.setting.getCommitEvery() != null) {
            this.commitEvery = this.setting.getCommitEvery();
            if (this.commitEvery > 0) {
                this.useCommit = true;
            }
        }
        this.dieOnError = this.setting.getDieOnError();
        this.result = new Result();
    }

    public void open(String uId) throws IOException {
        this.componentSchema = CommonUtils.getMainSchemaFromInputConnector((ComponentProperties)((ComponentProperties)this.properties));
        this.rejectSchema = CommonUtils.getRejectSchema((ComponentProperties)((ComponentProperties)this.properties));
        this.columnList = JDBCSQLBuilder.getInstance().createColumnList(this.setting, this.componentSchema);
        if (!this.setting.getClearDataInTable()) {
            return;
        }
        String sql = JDBCSQLBuilder.getInstance().generateSQL4DeleteTable(this.setting.getTablename());
        try {
            this.conn = this.sink.getConnection(this.runtime);
            try (Statement statement = this.conn.createStatement();){
                this.deleteCount += statement.executeUpdate(sql);
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public void write(Object datum) throws IOException {
        Object bufferSizeObject;
        if (this.runtime != null && (bufferSizeObject = this.runtime.getGlobalData(this.bufferSizeKey4Parallelize)) != null) {
            int bufferSize;
            this.commitEvery = bufferSize = ((Integer)bufferSizeObject).intValue();
            this.batchSize = bufferSize;
        }
        this.cleanWrites();
    }

    public abstract Result close() throws IOException;

    protected void commitAndCloseAtLast() {
        if (this.useExistedConnection) {
            return;
        }
        try {
            if (this.useCommit && this.commitCount > 0) {
                this.commitCount = 0;
                if (this.conn != null) {
                    this.conn.commit();
                }
            }
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public WriteOperation<Result> getWriteOperation() {
        return this.writeOperation;
    }

    protected IndexedRecordConverter<Object, ? extends IndexedRecord> getFactory(Object datum) {
        if (null == this.factory) {
            this.factory = JDBCAvroRegistry.get().createIndexedRecordConverter(datum.getClass());
        }
        return this.factory;
    }

    public List<IndexedRecord> getSuccessfulWrites() {
        return Collections.unmodifiableList(this.successfulWrites);
    }

    public List<IndexedRecord> getRejectedWrites() {
        return Collections.unmodifiableList(this.rejectedWrites);
    }

    public void cleanWrites() {
        this.successfulWrites.clear();
        this.rejectedWrites.clear();
    }

    protected void handleSuccess(IndexedRecord input) {
        ++this.successCount;
        this.successfulWrites.add(input);
    }

    protected void handleReject(IndexedRecord input, SQLException e) throws IOException {
        if (this.useBatch) {
            return;
        }
        ++this.rejectCount;
        GenericData.Record reject = new GenericData.Record(this.rejectSchema);
        for (Schema.Field rejectField : this.rejectSchema.getFields()) {
            Object rejectValue = null;
            Schema.Field inField = input.getSchema().getField(rejectField.name());
            if (inField != null) {
                rejectValue = input.get(inField.pos());
            } else if ("errorCode".equals(rejectField.name())) {
                rejectValue = e.getSQLState();
            } else if ("errorMessage".equals(rejectField.name())) {
                rejectValue = e.getMessage() + " - Line: " + this.result.totalCount;
            }
            reject.put(rejectField.pos(), rejectValue);
        }
        this.rejectedWrites.add((IndexedRecord)reject);
    }

    protected int executeCommit(PreparedStatement statement) throws SQLException {
        int result = 0;
        if (!this.useCommit) {
            return result;
        }
        ++this.commitCount;
        if (this.commitCount >= this.commitEvery) {
            this.commitCount = 0;
            if (this.useBatch && this.batchCount > 0) {
                result += this.executeBatchAndGetCount(statement);
                this.batchCount = 0;
            }
            this.conn.commit();
        }
        return result;
    }

    protected int execute(IndexedRecord input, PreparedStatement statement) throws SQLException {
        int count = 0;
        if (this.useBatch) {
            statement.addBatch();
            ++this.result.totalCount;
            ++this.batchCount;
            if (this.batchCount >= this.batchSize) {
                this.batchCount = 0;
                count = this.executeBatchAndGetCount(statement);
            }
        } else {
            count = statement.executeUpdate();
            ++this.result.totalCount;
        }
        this.handleSuccess(input);
        return count;
    }

    protected int executeBatchAndGetCount(PreparedStatement statement) throws SQLException {
        int result = 0;
        try {
            int[] batchResult = statement.executeBatch();
            result += this.sum(batchResult);
        }
        catch (BatchUpdateException e) {
            if (this.dieOnError) {
                throw e;
            }
            int[] batchResult = e.getUpdateCounts();
            result += this.sum(batchResult);
            LOG.warn(e.getMessage());
        }
        int count = statement.getUpdateCount();
        result = Math.max(result, count);
        return result;
    }

    private int sum(int[] batchResult) {
        int result = 0;
        for (int count : batchResult) {
            result += Math.max(count, 0);
        }
        return result;
    }

    protected void closeStatementQuietly(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void constructResult() {
        if (this.runtime != null) {
            this.runtime.setComponentData(this.runtime.getCurrentComponentId(), CommonUtils.getStudioNameFromProperty((String)"nbLineDeleted"), (Object)this.deleteCount);
            this.runtime.setComponentData(this.runtime.getCurrentComponentId(), CommonUtils.getStudioNameFromProperty((String)"nbLineInserted"), (Object)this.insertCount);
            this.runtime.setComponentData(this.runtime.getCurrentComponentId(), CommonUtils.getStudioNameFromProperty((String)"nbLineUpdated"), (Object)this.updateCount);
            this.runtime.setComponentData(this.runtime.getCurrentComponentId(), CommonUtils.getStudioNameFromProperty((String)"nbLineRejected"), (Object)this.rejectCount);
        }
        this.result.successCount = this.successCount;
        this.result.rejectCount = this.rejectCount;
    }

    protected int executeBatchAtLast() {
        if (this.useBatch && this.batchCount > 0) {
            try {
                this.batchCount = 0;
                return this.executeBatchAndGetCount(this.statement);
            }
            catch (SQLException e) {
                if (this.dieOnError) {
                    throw CommonUtils.newComponentException((Throwable)e);
                }
                LOG.warn(e.getMessage());
            }
        }
        return 0;
    }
}

