/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.reader;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.components.api.component.runtime.AbstractBoundedReader;
import org.talend.components.api.component.runtime.BoundedSource;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.avro.JDBCSPIndexedRecordCreator;
import org.talend.components.jdbc.runtime.JDBCSPSource;
import org.talend.components.jdbc.runtime.setting.AllSetting;

public class JDBCSPReader
extends AbstractBoundedReader<IndexedRecord> {
    protected RuntimeSettingProvider properties;
    protected RuntimeContainer container;
    protected Connection conn;
    private JDBCSPSource source;
    private CallableStatement cs;
    private Result result;
    private boolean useExistedConnection;
    private AllSetting setting;
    private JDBCSPIndexedRecordCreator indexedRecordCreator;

    public JDBCSPReader(RuntimeContainer container, JDBCSPSource source, RuntimeSettingProvider props) {
        super((BoundedSource)source);
        this.container = container;
        this.properties = props;
        this.source = (JDBCSPSource)this.getCurrentSource();
        this.setting = props.getRuntimeSetting();
        this.useExistedConnection = this.setting.getReferencedComponentId() != null;
    }

    public boolean start() throws IOException {
        this.result = new Result();
        try {
            this.conn = this.source.getConnection(this.container);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
        return true;
    }

    public boolean advance() throws IOException {
        return false;
    }

    public IndexedRecord getCurrent() {
        ++this.result.totalCount;
        try {
            this.cs = this.conn.prepareCall(this.source.getSPStatement(this.setting));
            Schema componentSchema = CommonUtils.getMainSchemaFromInputConnector((ComponentProperties)((ComponentProperties)this.source.properties));
            Schema outputSchema = CommonUtils.getOutputSchema((ComponentProperties)((ComponentProperties)this.source.properties));
            this.source.fillParameters(this.cs, componentSchema, null, null, this.setting);
            this.cs.execute();
            if (this.indexedRecordCreator == null) {
                this.indexedRecordCreator = new JDBCSPIndexedRecordCreator();
                this.indexedRecordCreator.init(componentSchema, outputSchema, this.setting);
            }
            IndexedRecord outputRecord = this.indexedRecordCreator.createOutputIndexedRecord(this.cs, null);
            return outputRecord;
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public void close() throws IOException {
        try {
            if (this.cs != null) {
                this.cs.close();
                this.cs = null;
            }
            if (!this.useExistedConnection && this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public Map<String, Object> getReturnValues() {
        return this.result.toMap();
    }
}

