/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime.reader;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.talend.components.api.component.runtime.AbstractBoundedReader;
import org.talend.components.api.component.runtime.BoundedSource;
import org.talend.components.api.component.runtime.Result;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.exception.DataRejectException;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.runtime.JDBCRowSource;
import org.talend.components.jdbc.runtime.JdbcRuntimeUtils;
import org.talend.components.jdbc.runtime.setting.AllSetting;

public class JDBCRowReader
extends AbstractBoundedReader<IndexedRecord> {
    protected RuntimeSettingProvider properties;
    protected RuntimeContainer container;
    protected Connection conn;
    protected ResultSet resultSet;
    private JDBCRowSource source;
    private PreparedStatement prepared_statement;
    private Statement statement;
    private Result result;
    private boolean useExistedConnection;
    private AllSetting setting;
    private boolean useCommit;
    private Integer commitEvery;
    private Schema outSchema;
    private Schema rejectSchema;

    public JDBCRowReader(RuntimeContainer container, JDBCRowSource source, RuntimeSettingProvider props) {
        super((BoundedSource)source);
        this.container = container;
        this.properties = props;
        this.source = (JDBCRowSource)this.getCurrentSource();
        this.setting = props.getRuntimeSetting();
        this.useExistedConnection = this.setting.getReferencedComponentId() != null;
        this.commitEvery = this.setting.getCommitEvery();
        this.useCommit = !this.useExistedConnection && this.commitEvery != null && this.commitEvery != 0;
        this.outSchema = CommonUtils.getOutputSchema((ComponentProperties)((ComponentProperties)this.properties));
        this.rejectSchema = CommonUtils.getRejectSchema((ComponentProperties)((ComponentProperties)this.properties));
    }

    public boolean start() throws IOException {
        if (this.container != null) {
            this.container.setComponentData(this.container.getCurrentComponentId(), CommonUtils.getStudioNameFromProperty((String)"query"), (Object)this.setting.getSql());
        }
        this.result = new Result();
        try {
            this.conn = this.source.getConnection(this.container);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
        return true;
    }

    public boolean advance() throws IOException {
        return false;
    }

    public IndexedRecord getCurrent() throws NoSuchElementException {
        try {
            boolean usePreparedStatement = this.setting.getUsePreparedStatement();
            String sql = this.setting.getSql();
            boolean propagateQueryResultSet = this.setting.getPropagateQueryResultSet();
            if (usePreparedStatement) {
                this.prepared_statement = this.conn.prepareStatement(sql);
                JdbcRuntimeUtils.setPreparedStatement(this.prepared_statement, this.setting.getIndexs(), this.setting.getTypes(), this.setting.getValues());
                if (propagateQueryResultSet) {
                    this.resultSet = this.prepared_statement.executeQuery();
                } else {
                    this.prepared_statement.execute();
                }
            } else {
                this.statement = this.conn.createStatement();
                if (propagateQueryResultSet) {
                    this.resultSet = this.statement.executeQuery(sql);
                } else {
                    this.statement.execute(sql);
                }
            }
            IndexedRecord output = this.handleSuccess(propagateQueryResultSet);
            if (this.useCommit) {
                this.conn.commit();
            }
            return output;
        }
        catch (SQLException e) {
            if (this.setting.getDieOnError()) {
                throw CommonUtils.newComponentException((Throwable)e);
            }
            this.handleReject(e);
            return null;
        }
    }

    private IndexedRecord handleSuccess(boolean propagateQueryResultSet) {
        GenericData.Record output = new GenericData.Record(this.outSchema);
        if (propagateQueryResultSet) {
            String columnName = this.setting.getUseColumn();
            for (Schema.Field outField : output.getSchema().getFields()) {
                if (!outField.name().equals(columnName)) continue;
                output.put(outField.pos(), (Object)this.resultSet);
            }
        }
        return output;
    }

    private void handleReject(SQLException e) {
        GenericData.Record reject = new GenericData.Record(this.rejectSchema);
        for (Schema.Field outField : reject.getSchema().getFields()) {
            String outValue = null;
            if ("errorCode".equals(outField.name())) {
                outValue = e.getSQLState();
            } else if ("errorMessage".equals(outField.name())) {
                outValue = e.getMessage();
            }
            reject.put(outField.pos(), (Object)outValue);
        }
        HashMap<String, String> resultMessage = new HashMap<String, String>();
        resultMessage.put("error", e.getMessage());
        resultMessage.put("errorCode", e.getSQLState());
        resultMessage.put("errorMessage", e.getMessage() + " - Line: " + this.result.totalCount);
        resultMessage.put("talend_record", (String)reject);
        throw new DataRejectException(resultMessage);
    }

    public void close() throws IOException {
        try {
            if (this.prepared_statement != null) {
                this.prepared_statement.close();
                this.prepared_statement = null;
            }
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
            if (!this.useExistedConnection && this.conn != null) {
                if (this.useCommit) {
                    this.conn.commit();
                }
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
    }

    public Map<String, Object> getReturnValues() {
        return this.result.toMap();
    }
}

