/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.common.runtime.SharedConnectionsPool;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.module.PreparedStatementTable;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.runtime.setting.JdbcRuntimeSourceOrSinkDefault;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.ValidationResultMutable;

public class JdbcRuntimeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcRuntimeUtils.class);

    public static Connection createConnection(final AllSetting setting) throws ClassNotFoundException, SQLException {
        if (!JdbcRuntimeUtils.valid(setting.getJdbcUrl())) {
            throw new RuntimeException("JDBC URL should not be empty, please set it");
        }
        final String driverClass = setting.getDriverClass();
        if (!JdbcRuntimeUtils.valid(driverClass)) {
            throw new RuntimeException("Driver Class should not be empty, please set it");
        }
        Class.forName(driverClass);
        Properties properties = new Properties(){
            {
                if (setting.getUsername() != null) {
                    this.setProperty("user", setting.getUsername());
                }
                if (setting.getPassword() != null) {
                    this.setProperty("password", setting.getPassword());
                }
                if (JdbcRuntimeUtils.isMysql(driverClass)) {
                    this.setProperty("allowLoadLocalInfile", "false");
                }
                if (JdbcRuntimeUtils.isMariadb(driverClass)) {
                    this.setProperty("allowLocalInfile", "false");
                }
            }
        };
        return DriverManager.getConnection(setting.getJdbcUrl(), properties);
    }

    private static boolean isMysql(String driverClass) {
        return driverClass.toLowerCase().contains("mysql");
    }

    private static boolean isMariadb(String driverClass) {
        return driverClass.toLowerCase().contains("mariadb");
    }

    private static boolean valid(String value) {
        return value != null && !value.isEmpty();
    }

    public static Connection fetchConnectionFromContextOrCreateNew(AllSetting setting, RuntimeContainer runtime) throws ClassNotFoundException, SQLException {
        if (runtime != null) {
            String refComponentId = setting.getReferencedComponentId();
            Object existedConn = runtime.getComponentData("conn", refComponentId);
            if (existedConn == null) {
                throw new RuntimeException("Referenced component: " + refComponentId + " is not connected");
            }
            return (Connection)existedConn;
        }
        return JdbcRuntimeUtils.createConnection(setting);
    }

    public static ValidationResult validate(RuntimeContainer runtime, JdbcRuntimeSourceOrSinkDefault ss) {
        ValidationResultMutable vr = new ValidationResultMutable();
        try {
            ss.initConnection(runtime);
        }
        catch (Exception ex) {
            vr.setStatus(ValidationResult.Result.ERROR);
            vr.setMessage(CommonUtils.correctExceptionInfo((Throwable)ex));
        }
        return vr;
    }

    public static void setPreparedStatement(PreparedStatement pstmt, List<Integer> indexs, List<String> types, List<Object> values) throws SQLException {
        block18: for (int i = 0; i < indexs.size(); ++i) {
            Integer index = indexs.get(i);
            PreparedStatementTable.Type type = PreparedStatementTable.Type.valueOf((String)types.get(i));
            Object value = values.get(i);
            switch (type) {
                case BigDecimal: {
                    pstmt.setBigDecimal(index, (BigDecimal)value);
                    continue block18;
                }
                case Blob: {
                    pstmt.setBlob((int)index, (Blob)value);
                    continue block18;
                }
                case Boolean: {
                    pstmt.setBoolean(index, (Boolean)value);
                    continue block18;
                }
                case Byte: {
                    pstmt.setByte(index, (Byte)value);
                    continue block18;
                }
                case Bytes: {
                    pstmt.setBytes(index, (byte[])value);
                    continue block18;
                }
                case Clob: {
                    pstmt.setClob((int)index, (Clob)value);
                    continue block18;
                }
                case Date: {
                    pstmt.setTimestamp(index, new Timestamp(((Date)value).getTime()));
                    continue block18;
                }
                case Double: {
                    pstmt.setDouble(index, (Double)value);
                    continue block18;
                }
                case Float: {
                    pstmt.setFloat(index, ((Float)value).floatValue());
                    continue block18;
                }
                case Int: {
                    pstmt.setInt(index, (Integer)value);
                    continue block18;
                }
                case Long: {
                    pstmt.setLong(index, (Long)value);
                    continue block18;
                }
                case Object: {
                    pstmt.setObject(index, value);
                    continue block18;
                }
                case Short: {
                    pstmt.setShort(index, (Short)value);
                    continue block18;
                }
                case String: {
                    pstmt.setString(index, (String)value);
                    continue block18;
                }
                case Time: {
                    pstmt.setTime(index, (Time)value);
                    continue block18;
                }
                case Null: {
                    pstmt.setNull(index, (Integer)value);
                    continue block18;
                }
                default: {
                    pstmt.setString(index, (String)value);
                }
            }
        }
    }

    public static Connection createConnectionOrGetFromSharedConnectionPoolOrDataSource(RuntimeContainer runtime, AllSetting setting, boolean readonly) throws SQLException, ClassNotFoundException {
        Connection conn = null;
        if (setting.getShareConnection()) {
            SharedConnectionsPool sharedConnectionPool = (SharedConnectionsPool)runtime.getGlobalData("GLOBAL_CONNECTION_POOL");
            conn = sharedConnectionPool.getDBConnection(setting.getDriverClass(), setting.getJdbcUrl(), setting.getUsername(), setting.getPassword(), setting.getSharedConnectionName());
        } else if (setting.getUseDataSource()) {
            Map dataSources = (Map)runtime.getGlobalData("KEY_DB_DATASOURCES_RAW");
            if (dataSources != null) {
                DataSource datasource = (DataSource)dataSources.get(setting.getDataSource());
                if (datasource == null) {
                    throw new RuntimeException("No DataSource with alias: " + setting.getDataSource() + " available!");
                }
                conn = datasource.getConnection();
                if (conn == null) {
                    throw new RuntimeException("Unable to get a pooled database connection from pool");
                }
            } else {
                conn = JdbcRuntimeUtils.createConnection(setting);
            }
        } else {
            conn = JdbcRuntimeUtils.createConnection(setting);
            if (readonly) {
                try {
                    conn.setReadOnly(setting.isReadOnly());
                }
                catch (SQLException e) {
                    LOGGER.debug("JDBC driver '{}' does not support read only mode.", (Object)setting.getDriverClass(), (Object)e);
                }
            }
        }
        return conn;
    }
}

