/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.module.SPParameterTable;
import org.talend.components.jdbc.runtime.JdbcRuntimeUtils;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.runtime.setting.JdbcRuntimeSourceOrSinkDefault;
import org.talend.components.jdbc.runtime.type.JDBCMapping;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.ValidationResultMutable;

public class JDBCSPSourceOrSink
extends JdbcRuntimeSourceOrSinkDefault {
    private static final long serialVersionUID = 1L;
    public RuntimeSettingProvider properties;
    protected AllSetting setting;
    private boolean useExistedConnection;

    public ValidationResult initialize(RuntimeContainer runtime, ComponentProperties properties) {
        this.properties = (RuntimeSettingProvider)properties;
        this.setting = this.properties.getRuntimeSetting();
        this.useExistedConnection = this.setting.getReferencedComponentId() != null;
        return ValidationResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult validate(RuntimeContainer runtime) {
        ValidationResultMutable vr = new ValidationResultMutable();
        Connection conn = null;
        try {
            conn = this.connect(runtime);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
        Schema componentSchema = CommonUtils.getMainSchemaFromInputConnector((ComponentProperties)((ComponentProperties)this.properties));
        try (CallableStatement cs = conn.prepareCall(this.getSPStatement(this.setting));){
            this.fillParameters(cs, componentSchema, null, null, this.setting);
            cs.execute();
        }
        catch (Exception ex) {
            vr.setStatus(ValidationResult.Result.ERROR);
            vr.setMessage(CommonUtils.correctExceptionInfo((Throwable)ex));
        }
        finally {
            if (!this.useExistedConnection) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return vr;
    }

    public void fillParameters(CallableStatement cs, Schema componentSchema, Schema inputSchema, IndexedRecord inputRecord, AllSetting setting) throws SQLException {
        if (setting.isFunction()) {
            String columnName = setting.getReturnResultIn();
            this.fillOutParameter(cs, componentSchema, columnName, 1);
        }
        List columns = setting.getSchemaColumns4SPParameters();
        List pts = setting.getParameterTypes();
        if (pts != null) {
            int i = setting.isFunction() ? 2 : 1;
            int j = -1;
            for (String each : pts) {
                String columnName = (String)columns.get(++j);
                SPParameterTable.ParameterType pt = SPParameterTable.ParameterType.valueOf((String)each);
                if (SPParameterTable.ParameterType.RECORDSET == pt) continue;
                if (SPParameterTable.ParameterType.OUT == pt || SPParameterTable.ParameterType.INOUT == pt) {
                    this.fillOutParameter(cs, componentSchema, columnName, i);
                }
                if (SPParameterTable.ParameterType.IN == pt || SPParameterTable.ParameterType.INOUT == pt) {
                    if (inputRecord != null) {
                        Schema.Field inField = CommonUtils.getField((Schema)componentSchema, (String)columnName);
                        Schema.Field inFieldInInput = CommonUtils.getField((Schema)inputSchema, (String)columnName);
                        JDBCMapping.setValue(i, cs, inField, inputRecord.get(inFieldInInput.pos()));
                    } else {
                        throw CommonUtils.newComponentException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (ExceptionContext)ExceptionContext.withBuilder().put("message", (Object)"input must exists for IN or INOUT parameters").build());
                    }
                }
                ++i;
            }
        }
    }

    private void fillOutParameter(CallableStatement cs, Schema componentSchema, String columnName, int i) throws SQLException {
        Schema.Field outField = CommonUtils.getField((Schema)componentSchema, (String)columnName);
        cs.registerOutParameter(i, JDBCMapping.getSQLTypeFromAvroType(outField));
    }

    public String getSPStatement(AllSetting setting) {
        String spName = setting.getSpName();
        boolean isFunction = setting.isFunction();
        List parameterTypes = setting.getParameterTypes();
        StringBuilder statementBuilder = new StringBuilder();
        statementBuilder.append("{");
        if (isFunction) {
            statementBuilder.append("? = ");
        }
        statementBuilder.append("call ").append(spName).append("(");
        if (parameterTypes != null) {
            boolean first = true;
            for (String each : parameterTypes) {
                SPParameterTable.ParameterType parameterType = SPParameterTable.ParameterType.valueOf((String)each);
                if (parameterType == SPParameterTable.ParameterType.RECORDSET) continue;
                if (first) {
                    statementBuilder.append("?");
                    first = false;
                    continue;
                }
                statementBuilder.append(",?");
            }
        }
        statementBuilder.append(")}");
        return statementBuilder.toString();
    }

    public Connection connect(RuntimeContainer runtime) throws ClassNotFoundException, SQLException {
        if (this.useExistedConnection) {
            return JdbcRuntimeUtils.fetchConnectionFromContextOrCreateNew(this.setting, runtime);
        }
        return JdbcRuntimeUtils.createConnectionOrGetFromSharedConnectionPoolOrDataSource(runtime, this.setting, false);
    }
}

