/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.runtime.JdbcRuntimeUtils;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.runtime.setting.JdbcRuntimeSourceOrSinkDefault;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.ValidationResultMutable;

public class JDBCRowSourceOrSink
extends JdbcRuntimeSourceOrSinkDefault {
    private static final long serialVersionUID = 1L;
    public RuntimeSettingProvider properties;
    protected AllSetting setting;
    private boolean useExistedConnection;
    private boolean useCommit;
    private Integer commitEvery;

    public ValidationResult initialize(RuntimeContainer runtime, ComponentProperties properties) {
        this.properties = (RuntimeSettingProvider)properties;
        this.setting = this.properties.getRuntimeSetting();
        this.useExistedConnection = this.setting.getReferencedComponentId() != null;
        this.commitEvery = this.setting.getCommitEvery();
        this.useCommit = !this.useExistedConnection && this.commitEvery != null && this.commitEvery != 0;
        return ValidationResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult validate(RuntimeContainer runtime) {
        if (runtime != null) {
            runtime.setComponentData(runtime.getCurrentComponentId(), CommonUtils.getStudioNameFromProperty((String)"query"), (Object)this.setting.getSql());
        }
        ValidationResultMutable vr = new ValidationResultMutable();
        AllSetting setting = this.properties.getRuntimeSetting();
        String sql = setting.getSql();
        boolean usePreparedStatement = setting.getUsePreparedStatement();
        boolean dieOnError = setting.getDieOnError();
        Connection conn = null;
        try {
            conn = this.connect(runtime);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw CommonUtils.newComponentException((Throwable)e);
        }
        try {
            if (usePreparedStatement) {
                try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                    JdbcRuntimeUtils.setPreparedStatement(pstmt, setting.getIndexs(), setting.getTypes(), setting.getValues());
                    pstmt.execute();
                }
            }
            try (Statement stmt = conn.createStatement();){
                stmt.execute(sql);
            }
            if (this.useCommit) {
                conn.commit();
            }
        }
        catch (Exception ex) {
            if (dieOnError) {
                vr.setStatus(ValidationResult.Result.ERROR);
                vr.setMessage(CommonUtils.correctExceptionInfo((Throwable)ex));
            } else {
                System.err.println(CommonUtils.correctExceptionInfo((Throwable)ex));
            }
        }
        finally {
            if (!this.useExistedConnection) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw CommonUtils.newComponentException((Throwable)e);
                }
            }
        }
        return vr;
    }

    public Connection connect(RuntimeContainer runtime) throws ClassNotFoundException, SQLException {
        if (this.useExistedConnection) {
            return JdbcRuntimeUtils.fetchConnectionFromContextOrCreateNew(this.setting, runtime);
        }
        Connection conn = JdbcRuntimeUtils.createConnectionOrGetFromSharedConnectionPoolOrDataSource(runtime, this.properties.getRuntimeSetting(), false);
        if (this.useCommit && conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        return conn;
    }
}

