/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.jdbc.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import org.talend.components.api.container.RuntimeContainer;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.components.jdbc.CommonUtils;
import org.talend.components.jdbc.RuntimeSettingProvider;
import org.talend.components.jdbc.runtime.setting.AllSetting;
import org.talend.components.jdbc.runtime.setting.JdbcRuntimeSourceOrSinkDefault;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.ValidationResultMutable;

public class JDBCCommitSourceOrSink
extends JdbcRuntimeSourceOrSinkDefault {
    private static final long serialVersionUID = 1L;
    private AllSetting setting;

    public ValidationResult initialize(RuntimeContainer runtime, ComponentProperties properties) {
        this.setting = ((RuntimeSettingProvider)properties).getRuntimeSetting();
        return ValidationResult.OK;
    }

    public ValidationResult validate(RuntimeContainer runtime) {
        ValidationResultMutable vr = new ValidationResultMutable();
        try {
            this.doCommitAction(runtime);
        }
        catch (Exception ex) {
            vr.setStatus(ValidationResult.Result.ERROR);
            vr.setMessage(CommonUtils.correctExceptionInfo((Throwable)ex));
        }
        return vr;
    }

    public void doCommitAction(RuntimeContainer runtime) throws SQLException {
        String refComponentId = this.setting.getReferencedComponentId();
        if (refComponentId != null && runtime != null) {
            Connection conn = (Connection)runtime.getComponentData("conn", refComponentId);
            if (conn != null && !conn.isClosed()) {
                conn.commit();
                if (this.setting.getCloseConnection()) {
                    conn.close();
                }
            }
        } else {
            throw new RuntimeException("Can't find the connection by the key");
        }
    }
}

