/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.serialize.jsonschema.mapping;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.serialize.jsonschema.UiSchemaConstants;

public class Mapper {
    protected final String uiAttribute;
    protected final String uiType;

    public Mapper(String uiAttribute, String uiType) {
        this.uiAttribute = uiAttribute;
        this.uiType = uiType;
    }

    public void processWidget(Widget widget, ObjectNode schema, boolean[] hasVisible) {
        if (widget.isAutoFocus()) {
            schema.put("ui:autofocus", true);
        }
        this.setType(schema);
        this.processOptions(widget, schema);
        if (!"hidden".equals(this.uiType)) {
            hasVisible[0] = true;
        }
    }

    protected void setType(ObjectNode schema) {
        schema.put(this.uiAttribute, this.uiType);
    }

    protected void processOptions(Widget widget, ObjectNode schema) {
        Map<String, String> optionsMap = UiSchemaConstants.getWidgetOptionsMapping().get(widget.getWidgetType());
        if (optionsMap != null) {
            ObjectNode options = JsonNodeFactory.instance.objectNode();
            for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
                if (widget.getConfigurationValue(entry.getKey()) != null) {
                    options.put(entry.getKey(), widget.getConfigurationValue(entry.getKey()).toString());
                    continue;
                }
                options.put(entry.getKey(), entry.getValue());
            }
            schema.set("ui:options", (JsonNode)options);
        }
    }
}

