/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.serialize;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import com.cedarsoftware.util.io.ObjectResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.serialize.PostDeserializeSetup;
import org.talend.daikon.serialize.migration.DeserializeDeletedFieldHandler;
import org.talend.daikon.serialize.migration.DeserializeMarker;
import org.talend.daikon.serialize.migration.PostDeserializeHandler;
import org.talend.daikon.serialize.migration.SerializeSetVersion;

public class SerializerDeserializer {
    public static final boolean PERSISTENT = true;
    public static final boolean TRANSIENT = false;
    private static final String VERSION_FIELD = "__version";

    public static <T> Deserialized<T> fromSerializedPersistent(String serialized, Class<T> serializedClass) {
        return SerializerDeserializer.fromSerialized(serialized, serializedClass, null, true);
    }

    public static <T> Deserialized<T> fromSerializedPersistent(String serialized, Class<T> serializedClass, PostDeserializeSetup setup) {
        return SerializerDeserializer.fromSerialized(serialized, serializedClass, setup, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Deserialized<T> fromSerialized(String serialized, Class<T> serializedClass, PostDeserializeSetup setup, boolean persistent) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(serialized.getBytes("UTF-8"));){
            Deserialized<T> deserialized = SerializerDeserializer.fromSerialized(is, serializedClass, setup, persistent);
            return deserialized;
        }
        catch (IOException e) {
            throw TalendRuntimeException.createUnexpectedException((Throwable)e);
        }
    }

    public static <T> Deserialized<T> fromSerialized(InputStream serialized, Class<T> serializedClass, PostDeserializeSetup setup, boolean persistent) {
        Deserialized d = new Deserialized();
        HashMap<PostDeserializeHandler, Integer> postDeserializeHandlers = new HashMap<PostDeserializeHandler, Integer>();
        HashMap<Class<DeserializeMarker>, CustomReader> readerMap = new HashMap<Class<DeserializeMarker>, CustomReader>();
        readerMap.put(DeserializeMarker.class, new CustomReader(postDeserializeHandlers));
        AtomicBoolean migratedDeleted = new AtomicBoolean(false);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("CUSTOM_READERS", readerMap);
        args.put("MISSING_FIELD_HANDLER", new MissingFieldHandler(migratedDeleted));
        if (serializedClass != null) {
            args.put("UNKNOWN_OBJECT", serializedClass.getCanonicalName());
        }
        d.object = JsonReader.jsonToJava((InputStream)serialized, args);
        boolean migrated = false;
        for (Map.Entry entry : postDeserializeHandlers.entrySet()) {
            migrated |= ((PostDeserializeHandler)entry.getKey()).postDeserialize((Integer)entry.getValue(), setup, persistent);
        }
        d.migrated = migrated || migratedDeleted.get();
        return d;
    }

    public static <T> String toSerializedPersistent(T object) {
        return SerializerDeserializer.toSerialized(object, true);
    }

    public static <T> String toSerialized(T object, boolean persistent) {
        return SerializerDeserializer.toSerialized(object, persistent, null);
    }

    public static String toSerialized(Object object, boolean persistent, Map<String, Object> jsonIoOptions) {
        JsonWriter.JsonClassWriterEx writer = new JsonWriter.JsonClassWriterEx(){

            public void write(Object o, boolean showType, Writer output, Map<String, Object> args) throws IOException {
                JsonWriter writer = JsonWriter.JsonClassWriterEx.Support.getWriter(args);
                int version = ((SerializeSetVersion)o).getVersionNumber();
                if (version > 0) {
                    boolean isReferenced = writer.getObjectsReferenced().containsKey(o);
                    output.write("\"__version\":" + version + (isReferenced ? "" : ","));
                }
                writer.writeObject(o, false, true);
            }
        };
        HashMap<Class<SerializeSetVersion>, 1> writerMap = new HashMap<Class<SerializeSetVersion>, 1>();
        writerMap.put(SerializeSetVersion.class, writer);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("CUSTOM_WRITERS", writerMap);
        if (jsonIoOptions != null) {
            HashMap<String, Object> additionalOption = new HashMap<String, Object>(jsonIoOptions);
            if (additionalOption.containsKey("CUSTOM_WRITERS")) {
                Map additionalWriterMap = (Map)additionalOption.get("CUSTOM_WRITERS");
                additionalOption.remove(additionalWriterMap);
                writerMap.putAll(additionalWriterMap);
            }
            args.putAll(jsonIoOptions);
        }
        return JsonWriter.objectToJson((Object)object, args);
    }

    private static class MissingFieldHandler
    implements JsonReader.MissingFieldHandler {
        AtomicBoolean migratedDeleted;

        MissingFieldHandler(AtomicBoolean md) {
            this.migratedDeleted = md;
        }

        public void fieldMissing(Object object, String fieldName, Object value) {
            if (!DeserializeDeletedFieldHandler.class.isAssignableFrom(object.getClass())) {
                return;
            }
            Boolean migrated = ((DeserializeDeletedFieldHandler)object).deletedField(fieldName, value);
            if (migrated.booleanValue()) {
                this.migratedDeleted.set(true);
            }
        }
    }

    private static class CustomReader
    implements JsonReader.JsonClassReaderEx {
        private Map<PostDeserializeHandler, Integer> postDeserializeHandlers;

        CustomReader(Map<PostDeserializeHandler, Integer> handlers) {
            this.postDeserializeHandlers = handlers;
        }

        public Object read(Object jOb, Deque<JsonObject<String, Object>> stack, Map<String, Object> args) {
            ObjectResolver resolver = (ObjectResolver)args.get("OBJECT_RESOLVER");
            JsonObject jsonObject = (JsonObject)jOb;
            Object versionObj = jsonObject.get((Object)SerializerDeserializer.VERSION_FIELD);
            long version = 0L;
            if (versionObj != null) {
                version = (Long)versionObj;
            }
            resolver.traverseFields(stack, (JsonObject)jOb);
            Object target = ((JsonObject)jOb).getTarget();
            if (target instanceof PostDeserializeHandler) {
                this.postDeserializeHandlers.put((PostDeserializeHandler)target, (int)version);
            }
            return target;
        }
    }

    public static class Deserialized<T> {
        public T object;
        public boolean migrated;
    }
}

