/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties.property;

import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.properties.property.Property;

public class EnumProperty<T extends Enum<T>>
extends Property<T> {
    private static final long serialVersionUID = -8979975127595348829L;

    public EnumProperty(Class<T> zeEnumType, String name) {
        super(zeEnumType, name, null);
        Object[] enumConstants = (Enum[])zeEnumType.getEnumConstants();
        this.setPossibleValues(enumConstants);
    }

    EnumProperty(String type, String name) {
        super(type, name);
    }

    @Override
    public T getValue() {
        Object value = this.storedValue;
        if (this.propertyValueEvaluator != null) {
            value = this.propertyValueEvaluator.evaluate(this, this.storedValue);
        }
        if (value instanceof String) {
            try {
                Class enumClass = ClassUtils.getClass((String)this.getType());
                return Enum.valueOf(enumClass, (String)value);
            }
            catch (ClassNotFoundException e) {
                TalendRuntimeException.unexpectedException((Throwable)e);
            }
        }
        return (T)((Enum)value);
    }

    String convertToInnerClassString(String type) {
        return StringUtils.replacePattern((String)type, (String)"([a-z0-9]*\\\\.[A-Z][^.]*)?((\\\\.)([A-Z][a-z0-9]*))", (String)"$1\\$$4");
    }
}

