/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.talend.daikon.properties.ValidationResult;

public class ValidationResults {
    private final Map<String, ValidationResult> validationResults = new LinkedHashMap<String, ValidationResult>();

    public Map<String, ValidationResult> getWarnings() {
        return this.filterResultsByStatus(ValidationResult.Result.WARNING);
    }

    public Map<String, ValidationResult> getErrors() {
        return this.filterResultsByStatus(ValidationResult.Result.ERROR);
    }

    private Map<String, ValidationResult> filterResultsByStatus(ValidationResult.Result status) {
        HashMap<String, ValidationResult> filteredValues = new HashMap<String, ValidationResult>();
        for (Map.Entry<String, ValidationResult> vr : this.validationResults.entrySet()) {
            if (status != vr.getValue().getStatus()) continue;
            filteredValues.put(vr.getKey(), vr.getValue());
        }
        return filteredValues;
    }

    public void addValidationResults(ValidationResults value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        Map<String, ValidationResult> allValidationResults = value.getAll();
        for (Map.Entry<String, ValidationResult> validationResult : allValidationResults.entrySet()) {
            this.addValidationResult(validationResult.getKey(), validationResult.getValue());
        }
    }

    public void addValidationResult(String propName, ValidationResult value) {
        if (value == null) {
            return;
        }
        ValidationResult containing = this.validationResults.get(propName);
        if (containing == null || this.shouldRewrite(containing, value)) {
            this.validationResults.put(propName, value);
        }
    }

    private boolean shouldRewrite(ValidationResult containing, ValidationResult newValue) {
        return containing.getStatus() == ValidationResult.Result.OK && newValue.getStatus() != ValidationResult.Result.OK || containing.getStatus() == ValidationResult.Result.WARNING && newValue.getStatus() == ValidationResult.Result.ERROR;
    }

    public Map<String, ValidationResult> getAll() {
        return Collections.unmodifiableMap(this.validationResults);
    }

    public ValidationResult.Result calculateValidationStatus() {
        if (!this.getErrors().isEmpty()) {
            return ValidationResult.Result.ERROR;
        }
        if (!this.getWarnings().isEmpty()) {
            return ValidationResult.Result.WARNING;
        }
        return ValidationResult.Result.OK;
    }

    private String getGeneralProblemsMessage() {
        StringBuilder message = new StringBuilder();
        this.addMessages(message, this.getErrors().values());
        this.addMessages(message, this.getWarnings().values());
        return message.toString();
    }

    private void addMessages(StringBuilder sb, Collection<ValidationResult> results) {
        for (ValidationResult vr : results) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(vr.toString());
        }
    }

    public String toString() {
        String value = this.getGeneralProblemsMessage();
        return value.isEmpty() ? "OK" : value;
    }

    public boolean isEmpty() {
        return this.validationResults.isEmpty();
    }
}

