/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesImpl;
import org.talend.daikon.properties.presentation.Form;

public class PropertiesList<T extends Properties>
extends PropertiesImpl {
    public static final String ROW_NAME_PREFIX = "row";
    private String minItems = "1";
    private String maxItems = "10";
    public List<T> subProperties = new ArrayList<T>();
    public transient T defaultProperties;
    private final transient NestedPropertiesFactory<T> factory;

    public PropertiesList(String name, NestedPropertiesFactory<T> factory) {
        super(name);
        this.factory = factory;
        this.defaultProperties = factory.createAndInit("defaultProperties");
    }

    @Override
    public void setupLayout() {
        super.setupLayout();
        Form main = new Form(this, "Main");
        this.layoutPropertiesOnForm(main);
    }

    protected void layoutPropertiesOnForm(Form form) {
        for (Properties props : this.subProperties) {
            form.addRow(props.getForm("Main"));
        }
    }

    @Override
    public void refreshLayout(Form form) {
        super.refreshLayout(form);
        if ("Main".equals(form.getName())) {
            form.clearForm();
            this.layoutPropertiesOnForm(form);
        }
    }

    public Collection<T> getPropertiesList() {
        return Collections.unmodifiableCollection(this.subProperties);
    }

    public void addRow(T props) {
        this.subProperties.add(props);
        this.getForm("Main").addRow(props.getForm("Main"));
    }

    public T createAndAddRow() {
        T newRow = this.factory.createAndInit(ROW_NAME_PREFIX + (this.subProperties.size() + 1));
        newRow.init();
        this.addRow(newRow);
        return newRow;
    }

    public void setRows(Collection<T> subProps) {
        this.subProperties.clear();
        this.subProperties.addAll(subProps);
        this.refreshLayout(this.getForm("Main"));
    }

    public void addAllRows(Collection<T> props) {
        this.subProperties.addAll(props);
        this.refreshLayout(this.getForm("Main"));
    }

    public T getDefaultProperties() {
        return this.defaultProperties;
    }

    public NestedPropertiesFactory<T> getNestedPropertiesFactory() {
        return this.factory;
    }

    public String getMinItems() {
        return this.minItems;
    }

    public void setMinItems(String minItems) {
        this.minItems = minItems;
    }

    public String getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(String maxItems) {
        this.maxItems = maxItems;
    }

    public static interface NestedPropertiesFactory<T extends Properties> {
        public T createAndInit(String var1);
    }
}

