/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.pattern.word;

import java.util.ArrayList;
import java.util.List;
import org.talend.daikon.pattern.PatternRegexUtils;
import org.talend.daikon.pattern.word.WordPattern;

public class WordPatternToRegex {
    private WordPatternToRegex() {
    }

    public static String toRegex(String pattern, boolean caseSensitive) {
        StringBuilder sb = new StringBuilder();
        sb.append("^");
        for (String current : WordPatternToRegex.splitPattern(pattern)) {
            WordPattern wordPattern = WordPattern.get(current);
            String regex = wordPattern == null ? PatternRegexUtils.escapeCharacters(current) : (caseSensitive ? wordPattern.getCaseSensitive() : wordPattern.getCaseInsensitive());
            sb.append(regex);
        }
        sb.append("$");
        return sb.toString();
    }

    private static List<String> splitPattern(String pattern) {
        ArrayList<String> result = new ArrayList<String>();
        if (pattern.startsWith("[")) {
            int closeBracket = pattern.indexOf(93);
            int openBracket = pattern.indexOf(91, 1);
            if (closeBracket > 0 && (closeBracket < openBracket || openBracket == -1)) {
                String extracted = pattern.substring(0, closeBracket + 1);
                result.add(extracted);
                if (closeBracket + 1 < pattern.length()) {
                    result.addAll(WordPatternToRegex.splitPattern(pattern.substring(closeBracket + 1)));
                }
            } else if (closeBracket == -1) {
                result.add(pattern);
            } else {
                result.add(pattern.substring(0, openBracket));
                result.addAll(WordPatternToRegex.splitPattern(pattern.substring(openBracket)));
            }
        } else {
            int openBracket = pattern.indexOf(91, 1);
            if (openBracket == -1) {
                result.add(pattern);
            } else {
                result.add(pattern.substring(0, openBracket));
                result.addAll(WordPatternToRegex.splitPattern(pattern.substring(openBracket)));
            }
        }
        return result;
    }
}

