/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.pattern.character;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.talend.daikon.pattern.character.CharPatternToRegexConstants;

public enum CharPattern {
    DIGIT('9', CharPatternToRegexConstants.DIGIT),
    LOWER_LATIN('a', CharPatternToRegexConstants.LOWER_LATIN),
    LOWER_LATIN_RARE('a', CharPatternToRegexConstants.LOWER_LATIN_RARE),
    UPPER_LATIN('A', CharPatternToRegexConstants.UPPER_LATIN),
    UPPER_LATIN_RARE('A', CharPatternToRegexConstants.UPPER_LATIN_RARE),
    FULLWIDTH_DIGIT('9', CharPatternToRegexConstants.FULLWIDTH_DIGIT),
    FULLWIDTH_LOWER_LATIN('a', CharPatternToRegexConstants.FULLWIDTH_LOWER_LATIN),
    FULLWIDTH_UPPER_LATIN('A', CharPatternToRegexConstants.FULLWIDTH_UPPER_LATIN),
    HIRAGANA('H', CharPatternToRegexConstants.HIRAGANA),
    HALFWIDTH_KATAKANA('k', CharPatternToRegexConstants.HALFWIDTH_KATAKANA),
    FULLWIDTH_KATAKANA('K', CharPatternToRegexConstants.FULLWIDTH_KATAKANA),
    KANJI('C', CharPatternToRegexConstants.KANJI),
    KANJI_RARE('C', CharPatternToRegexConstants.KANJI_RARE),
    HANGUL('G', CharPatternToRegexConstants.HANGUL);

    private Character replaceChar;
    private CharPatternToRegexConstants pattern;
    private Set<Integer> codePointSet = new HashSet<Integer>();
    private List<Integer> codePointList = new ArrayList<Integer>();
    private static final Map<Character, CharPattern> lookup;

    public static CharPattern get(String pattern) {
        return lookup.get(pattern);
    }

    private CharPattern(char replace, CharPatternToRegexConstants pattern) {
        this.replaceChar = Character.valueOf(replace);
        this.pattern = pattern;
        this.buildCharacters(pattern.getRange());
    }

    private void buildCharacters(String pattern) {
        for (String subPattern : pattern.substring(1, pattern.length() - 1).split("\\|")) {
            if (this.isInterval(subPattern)) {
                String[] startEnd = subPattern.split("-");
                Integer start = this.getCodePointAt(startEnd[0].substring(1));
                Integer end = this.getCodePointAt(startEnd[1].substring(0, startEnd[1].length() - 1));
                for (int i = start.intValue(); i <= end; ++i) {
                    this.fillSetAndList(i, subPattern);
                }
                continue;
            }
            Integer codePoint = this.getCodePointAt(subPattern);
            this.fillSetAndList(codePoint, subPattern);
        }
    }

    private void fillSetAndList(int i, String subPattern) {
        if (this.codePointSet.contains(i)) {
            throw new IllegalArgumentException("Pattern " + subPattern + " is in conflict with another pattern");
        }
        this.codePointSet.add(i);
        this.codePointList.add(i);
    }

    private boolean isInterval(String subPattern) {
        return subPattern.contains("-");
    }

    private Integer getCodePointAt(String s) {
        return Integer.parseInt(s.substring(3, s.length() - 1), 16);
    }

    public Character getReplaceChar() {
        return this.replaceChar;
    }

    public CharPatternToRegexConstants getPattern() {
        return this.pattern;
    }

    public boolean contains(Integer codePoint) {
        return this.codePointSet.contains(codePoint);
    }

    public Integer getCodePointAt(int position) {
        return this.codePointList.get(position);
    }

    public int getCodePointSize() {
        return this.codePointList.size();
    }

    static {
        lookup = new HashMap<Character, CharPattern>();
        for (CharPattern value : CharPattern.values()) {
            lookup.put(value.getReplaceChar(), value);
        }
    }
}

