/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.i18n.tag;

import java.util.regex.Pattern;
import org.talend.daikon.i18n.tag.Tag;

public class TagUtils {
    public static boolean hasTag(Tag tag, String keyword) {
        Pattern pattern = Pattern.compile(keyword, 66);
        String translatedValue = TagUtils.getTranslatedPathToRoot(tag);
        String value = TagUtils.getPathToRoot(tag);
        return pattern.matcher(translatedValue).find() || pattern.matcher(value).find();
    }

    public static String getTranslatedPathToRoot(Tag tag) {
        Tag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return tag.getTranslatedValue();
        }
        return TagUtils.getTranslatedPathToRoot(parentTag) + "/" + tag.getTranslatedValue();
    }

    public static String getPathToRoot(Tag tag) {
        Tag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return tag.getValue();
        }
        return TagUtils.getPathToRoot(parentTag) + "/" + tag.getValue();
    }
}

