/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.converter;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.talend.daikon.converter.Converter;
import org.talend.daikon.converter.TypeConverterErrorCode;

public class LocalDateConverter
extends Converter<LocalDate> {
    public static final String FORMATTER = "formatter";

    @Override
    public LocalDate convert(Object value) {
        if (value == null) {
            return (LocalDate)this.returnDefaultValue();
        }
        if (this.properties.containsKey(FORMATTER)) {
            try {
                return LocalDate.parse(value.toString(), this.getDateTimeFormatter());
            }
            catch (DateTimeParseException dtpe) {
                throw TypeConverterErrorCode.createCannotParseWithFormat(dtpe, value.toString(), this.getDateTimeFormatter().toString());
            }
        }
        return LocalDate.parse(value.toString());
    }

    public LocalDateConverter withDateTimeFormatter(DateTimeFormatter formatter) {
        this.properties.put(FORMATTER, formatter);
        return this;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.properties.get(FORMATTER);
    }
}

