/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.visitor.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.talend.daikon.avro.visitor.path.TraversalPath;
import org.talend.daikon.avro.visitor.record.AbstractVisitableStructure;
import org.talend.daikon.avro.visitor.record.RecordVisitor;
import org.talend.daikon.avro.visitor.record.VisitableStructure;
import org.talend.daikon.avro.visitor.record.VisitableStructureFactory;

public class VisitableMap
extends AbstractVisitableStructure<Map<Utf8, Object>> {
    public VisitableMap(Map<Utf8, Object> value, TraversalPath path) {
        super(value, path);
    }

    @Override
    public void accept(RecordVisitor visitor) {
        visitor.visit(this);
    }

    public Iterator<VisitableStructure> getValues() {
        Schema schema = this.getPath().last().getSchema();
        Schema valueSchema = schema.getValueType();
        ArrayList<VisitableStructure> entries = new ArrayList<VisitableStructure>(((Map)this.getValue()).size());
        for (Map.Entry entry : ((Map)this.getValue()).entrySet()) {
            String key = ((Utf8)entry.getKey()).toString();
            Object value = entry.getValue();
            TraversalPath path = this.getPath().appendMapEntry(key);
            VisitableStructure child = VisitableStructureFactory.createVisitableStructure(valueSchema, value, path);
            entries.add(child);
        }
        return Collections.unmodifiableList(entries).iterator();
    }
}

