/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.converter;

import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.talend.daikon.avro.converter.ComparableIndexedRecordBase;
import org.talend.daikon.avro.converter.IndexedRecordConverter;

public class SingleColumnIndexedRecordConverter<DatumT>
implements IndexedRecordConverter<DatumT, PrimitiveAsIndexedRecordAdapter<DatumT>> {
    private final Class<DatumT> mDatumClass;
    private final Schema mSchema;

    public SingleColumnIndexedRecordConverter(Class<DatumT> datumClass, Schema fieldSchema) {
        this(datumClass, fieldSchema, SingleColumnIndexedRecordConverter.createRecordName(datumClass), "field");
    }

    public SingleColumnIndexedRecordConverter(Class<DatumT> datumClass, Schema fieldSchema, String recordName, String fieldName) {
        this.mDatumClass = datumClass;
        this.mSchema = (Schema)SchemaBuilder.record((String)recordName).fields().name(fieldName).type(fieldSchema).noDefault().endRecord();
    }

    public static String createRecordName(Class<?> datumClass) {
        if (datumClass.isArray()) {
            return datumClass.getComponentType().getSimpleName() + "ArrayRecord";
        }
        return datumClass.getSimpleName() + "Record";
    }

    @Override
    public Class<DatumT> getDatumClass() {
        return this.mDatumClass;
    }

    @Override
    public Schema getSchema() {
        return this.mSchema;
    }

    @Override
    public void setSchema(Schema s) {
        throw new IndexedRecordConverter.UnmodifiableAdapterException();
    }

    @Override
    public PrimitiveAsIndexedRecordAdapter<DatumT> convertToAvro(DatumT value) {
        return new PrimitiveAsIndexedRecordAdapter(this.mSchema, value);
    }

    @Override
    public DatumT convertToDatum(PrimitiveAsIndexedRecordAdapter<DatumT> value) {
        return (DatumT)((PrimitiveAsIndexedRecordAdapter)value).mValue;
    }

    public static class PrimitiveAsIndexedRecordAdapter<T>
    extends ComparableIndexedRecordBase {
        private final T mValue;
        private final Schema mSchema;

        private PrimitiveAsIndexedRecordAdapter(Schema schema, T value) {
            this.mSchema = schema;
            this.mValue = value;
        }

        public Schema getSchema() {
            return this.mSchema;
        }

        public T get(int i) {
            return this.mValue;
        }

        public void put(int i, Object v) {
            throw new IndexedRecordConverter.UnmodifiableAdapterException();
        }
    }
}

