/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.converter;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.container.ContainerReaderByIndex;
import org.talend.daikon.avro.container.ContainerWriterByIndex;
import org.talend.daikon.avro.converter.AvroConverter;
import org.talend.daikon.avro.converter.ComparableIndexedRecordBase;
import org.talend.daikon.avro.converter.HasNestedAvroConverter;
import org.talend.daikon.avro.converter.IndexedRecordConverter;

public abstract class CachedIndexedRecordConverterBase<ContainerDataSpecT, FieldDataSpecT, GettableT, SettableT>
implements IndexedRecordConverter<GettableT, IndexedRecord>,
HasNestedAvroConverter<GettableT, IndexedRecord> {
    private Schema schema;
    private final Class<FieldDataSpecT> fieldDataSpecClass;
    protected transient ContainerDataSpecT containerDataSpec;
    protected transient FieldDataSpecT[] fieldType;
    protected transient AvroConverter[] fieldConverter;
    protected transient ContainerReaderByIndex<? super GettableT, ?>[] fieldReader;
    protected transient ContainerWriterByIndex<? super SettableT, ?>[] fieldWriter;

    protected CachedIndexedRecordConverterBase(Class<FieldDataSpecT> fieldDataSpecClass) {
        this.fieldDataSpecClass = fieldDataSpecClass;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
        if (schema != null) {
            this.fieldType = (Object[])Array.newInstance(this.fieldDataSpecClass, AvroUtils.unwrapIfNullable(schema).getFields().size());
            this.fieldConverter = new AvroConverter[this.fieldType.length];
        } else {
            this.fieldType = null;
            this.fieldConverter = null;
            this.fieldWriter = null;
            this.fieldReader = null;
        }
    }

    public ContainerDataSpecT getContainerDataSpec() {
        return this.containerDataSpec;
    }

    public void setContainerDataSpec(ContainerDataSpecT containerType) {
        this.containerDataSpec = containerType;
        this.setSchemaFromContainerDataSpec(containerType);
    }

    protected abstract void setSchemaFromContainerDataSpec(ContainerDataSpecT var1);

    protected abstract void setContainerDataSpecFromInstance(GettableT var1);

    public abstract FieldDataSpecT getFieldDataSpec(int var1);

    protected abstract ContainerReaderByIndex<? super GettableT, ?> getFieldReader(FieldDataSpecT var1);

    protected abstract ContainerWriterByIndex<? super SettableT, ?> getFieldWriter(FieldDataSpecT var1);

    protected abstract void setToNull(SettableT var1, int var2);

    protected abstract AvroConverter getConverter(FieldDataSpecT var1, Schema var2, Class<?> var3);

    protected abstract SettableT createOrGetInstance();

    @Override
    public Iterable<AvroConverter<?, ?>> getNestedAvroConverters() {
        for (Schema.Field f : AvroUtils.unwrapIfNullable(this.getSchema()).getFields()) {
            int i = f.pos();
            if (this.fieldType[i] == null) {
                this.fieldType[i] = this.getFieldDataSpec(i);
            }
            if (this.fieldConverter[i] != null) continue;
            this.fieldConverter[i] = this.getConverter(this.fieldType[i], f.schema(), null);
        }
        return Arrays.asList(this.fieldConverter);
    }

    @Override
    public IndexedRecord convertToAvro(GettableT gettable) {
        if (this.containerDataSpec == null) {
            this.setContainerDataSpecFromInstance(gettable);
        }
        IndexedRecordAdapterWithCache record = new IndexedRecordAdapterWithCache(gettable);
        if (this.fieldReader == null) {
            this.fieldReader = new ContainerReaderByIndex[this.fieldType.length];
            for (Schema.Field f : AvroUtils.unwrapIfNullable(this.getSchema()).getFields()) {
                int i = f.pos();
                this.fieldType[i] = this.getFieldDataSpec(i);
                this.fieldReader[i] = this.getFieldReader(this.fieldType[i]);
            }
        }
        return record;
    }

    @Override
    public GettableT convertToDatum(IndexedRecord record) {
        if (this.fieldWriter == null) {
            this.fieldWriter = new ContainerWriterByIndex[this.fieldType.length];
            for (Schema.Field f : AvroUtils.unwrapIfNullable(this.getSchema()).getFields()) {
                int i = f.pos();
                this.fieldType[i] = this.getFieldDataSpec(i);
                this.fieldWriter[i] = this.getFieldWriter(this.fieldType[i]);
            }
        }
        SettableT value = this.createOrGetInstance();
        for (Schema.Field f : AvroUtils.unwrapIfNullable(this.getSchema()).getFields()) {
            Object fieldValue;
            int fieldIndex = f.pos();
            if (this.fieldType[fieldIndex] == null) {
                this.fieldType[fieldIndex] = this.getFieldDataSpec(fieldIndex);
            }
            if ((fieldValue = record.get(fieldIndex)) == null) {
                this.setToNull(value, fieldIndex);
                continue;
            }
            if (this.fieldConverter[fieldIndex] == null) {
                this.fieldConverter[fieldIndex] = this.getConverter(this.fieldType[fieldIndex], f.schema(), fieldValue.getClass());
            }
            ContainerWriterByIndex<SettableT, ?> writer = this.fieldWriter[fieldIndex];
            writer.writeValue(value, f.pos(), this.fieldConverter[fieldIndex].convertToDatum(fieldValue));
        }
        return (GettableT)value;
    }

    private class IndexedRecordAdapterWithCache
    extends ComparableIndexedRecordBase {
        public GettableT gettable;

        public IndexedRecordAdapterWithCache(GettableT gettable) {
            this.gettable = gettable;
        }

        public Schema getSchema() {
            return CachedIndexedRecordConverterBase.this.schema;
        }

        public void put(int i, Object v) {
            throw new IndexedRecordConverter.UnmodifiableAdapterException();
        }

        public Object get(int i) {
            Object value = CachedIndexedRecordConverterBase.this.fieldReader[i].readValue(this.gettable, i);
            if (value == null) {
                return null;
            }
            if (CachedIndexedRecordConverterBase.this.fieldConverter[i] == null) {
                CachedIndexedRecordConverterBase.this.fieldConverter[i] = CachedIndexedRecordConverterBase.this.getConverter(CachedIndexedRecordConverterBase.this.fieldType[i], ((Schema.Field)AvroUtils.unwrapIfNullable(CachedIndexedRecordConverterBase.this.schema).getFields().get(i)).schema(), value.getClass());
            }
            if (CachedIndexedRecordConverterBase.this.fieldConverter[i] != null) {
                value = CachedIndexedRecordConverterBase.this.fieldConverter[i].convertToAvro(value);
            }
            return value;
        }

        @Override
        public String toString() {
            return this.gettable.toString();
        }
    }
}

