/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.util.List;
import java.util.ListIterator;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.tree.Node;
import org.jpmml.evaluator.visitors.ElementHashMap;
import org.jpmml.evaluator.visitors.ElementKey;
import org.jpmml.model.visitors.AbstractVisitor;

public class ScoreDistributionInterner
extends AbstractVisitor {
    private ElementHashMap<ScoreDistribution> cache = new ElementHashMap<ScoreDistribution>(){

        @Override
        public ElementKey createKey(ScoreDistribution scoreDistribution) {
            Object[] content = new Object[]{scoreDistribution.requireValue(), scoreDistribution.requireRecordCount(), scoreDistribution.getProbability(), scoreDistribution.getConfidence()};
            return new ElementKey(content);
        }
    };

    public VisitorAction visit(Node node) {
        if (node.hasScoreDistributions()) {
            List scoreDistributions = node.getScoreDistributions();
            ListIterator<ScoreDistribution> it = scoreDistributions.listIterator();
            while (it.hasNext()) {
                it.set(this.intern((ScoreDistribution)it.next()));
            }
        }
        return super.visit(node);
    }

    private ScoreDistribution intern(ScoreDistribution scoreDistribution) {
        if (scoreDistribution == null || scoreDistribution.hasExtensions()) {
            return scoreDistribution;
        }
        return this.cache.intern(scoreDistribution);
    }
}

