/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import org.dmg.pmml.Array;
import org.dmg.pmml.False;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.ExtensionUtil;
import org.jpmml.evaluator.visitors.ElementHashMap;
import org.jpmml.evaluator.visitors.ElementKey;
import org.jpmml.model.visitors.PredicateFilterer;
import org.jpmml.model.visitors.Resettable;

public class PredicateInterner
extends PredicateFilterer
implements Resettable {
    private ElementHashMap<SimplePredicate> simplePredicateCache = new ElementHashMap<SimplePredicate>(){

        @Override
        public ElementKey createKey(SimplePredicate simplePredicate) {
            Object[] content = new Object[]{simplePredicate.requireField(), simplePredicate.requireOperator(), simplePredicate.getValue()};
            return new ElementKey(content);
        }
    };
    private ElementHashMap<SimpleSetPredicate> simpleSetPredicateCache = new ElementHashMap<SimpleSetPredicate>(){

        @Override
        public ElementKey createKey(SimpleSetPredicate simpleSetPredicate) {
            Array array = simpleSetPredicate.requireArray();
            Object[] content = new Object[]{simpleSetPredicate.requireField(), simpleSetPredicate.requireBooleanOperator(), ArrayUtil.getContent(array)};
            return new ElementKey(content);
        }
    };

    public void reset() {
        this.simplePredicateCache.clear();
        this.simpleSetPredicateCache.clear();
    }

    public Predicate filter(Predicate predicate) {
        if (predicate == null || ExtensionUtil.hasExtensions((PMMLObject)predicate)) {
            return predicate;
        }
        return this.intern(predicate);
    }

    public Predicate intern(Predicate predicate) {
        if (predicate instanceof SimplePredicate) {
            return this.intern((SimplePredicate)predicate);
        }
        if (predicate instanceof SimpleSetPredicate) {
            return this.intern((SimpleSetPredicate)predicate);
        }
        if (predicate instanceof True) {
            return True.INSTANCE;
        }
        if (predicate instanceof False) {
            return False.INSTANCE;
        }
        return predicate;
    }

    private SimplePredicate intern(SimplePredicate simplePredicate) {
        return this.simplePredicateCache.intern(simplePredicate);
    }

    private SimpleSetPredicate intern(SimpleSetPredicate simpleSetPredicate) {
        return this.simpleSetPredicateCache.intern(simpleSetPredicate);
    }
}

