/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.tree;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Targets;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.PMMLAttributes;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.annotations.Functionality;
import org.jpmml.evaluator.tree.TreeModelEvaluator;
import org.jpmml.model.MissingAttributeException;

@Functionality(value={ResultFeature.PREDICTED_VALUE, ResultFeature.PREDICTED_DISPLAY_VALUE})
public class SimpleTreeModelEvaluator
extends TreeModelEvaluator {
    private SimpleTreeModelEvaluator() {
    }

    public SimpleTreeModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, TreeModel.class));
    }

    public SimpleTreeModelEvaluator(PMML pmml, TreeModel treeModel) {
        super(pmml, treeModel);
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        switch (missingValueStrategy) {
            case NULL_PREDICTION: 
            case LAST_PREDICTION: 
            case DEFAULT_CHILD: 
            case NONE: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum<?>)missingValueStrategy);
            }
        }
        Targets targets = treeModel.getTargets();
        if (targets != null) {
            throw new UnsupportedElementException((PMMLObject)targets);
        }
    }

    @Override
    protected <V extends Number> Map<String, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateAny(context);
    }

    @Override
    protected <V extends Number> Map<String, ?> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateAny(context);
    }

    private Map<String, ?> evaluateAny(EvaluationContext context) {
        TargetField targetField = this.getTargetField();
        Object result = null;
        Node node = this.evaluateTree(context);
        if (node != null) {
            Object score = node.getScore();
            result = TypeUtil.parseOrCast(targetField.getDataType(), score);
        }
        return Collections.singletonMap(targetField.getFieldName(), result);
    }

    private Node evaluateTree(EvaluationContext context) {
        TreeModel treeModel = (TreeModel)this.getModel();
        Node root = treeModel.requireNode();
        Boolean status = PredicateUtil.evaluatePredicateContainer(root, context);
        if (status == null || !status.booleanValue()) {
            return null;
        }
        Node node = root;
        block10: while (node.hasNodes()) {
            List children = node.getNodes();
            int max = children.size();
            block11: for (int i = 0; i < max; ++i) {
                Node child = (Node)children.get(i);
                Boolean status2 = PredicateUtil.evaluatePredicateContainer(child, context);
                if (status2 == null) {
                    TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
                    switch (missingValueStrategy) {
                        case NULL_PREDICTION: {
                            return null;
                        }
                        case LAST_PREDICTION: {
                            break block10;
                        }
                        case DEFAULT_CHILD: {
                            Node defaultChild;
                            node = defaultChild = SimpleTreeModelEvaluator.findDefaultChild(node);
                            continue block10;
                        }
                        case NONE: {
                            continue block11;
                        }
                        default: {
                            throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum<?>)missingValueStrategy);
                        }
                    }
                }
                if (!status2.booleanValue()) continue;
                node = child;
                continue block10;
            }
            TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
            switch (noTrueChildStrategy) {
                case RETURN_NULL_PREDICTION: {
                    return null;
                }
                case RETURN_LAST_PREDICTION: {
                    if (node.hasScore()) break block10;
                    return null;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum<?>)noTrueChildStrategy);
                }
            }
        }
        if (!node.hasScore()) {
            throw new MissingAttributeException((PMMLObject)node, PMMLAttributes.COMPLEXNODE_SCORE);
        }
        return node;
    }
}

