/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.jpmml.evaluator.ModelManager;
import org.jpmml.evaluator.ServiceFactory;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.UnsupportedMarkupException;
import org.jpmml.evaluator.annotations.Functionality;
import org.jpmml.model.InvalidMarkupException;
import org.jpmml.model.PMMLException;

public abstract class ModelManagerFactory<S extends ModelManager<?>>
extends ServiceFactory<Model, S> {
    protected ModelManagerFactory() {
    }

    protected ModelManagerFactory(Class<S> serviceClazz) {
        super(Model.class, serviceClazz);
    }

    public S newModelManager(PMML pmml, Model model) {
        return this.newModelManager(pmml, model, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public S newModelManager(PMML pmml, Model model, Set<ResultFeature> extraResultFeatures) {
        pmml = Objects.requireNonNull(pmml);
        model = Objects.requireNonNull(model);
        Output output = model.getOutput();
        Set<ResultFeature> resultFeatures = ModelManager.collectResultFeatures(output);
        if (extraResultFeatures != null && !extraResultFeatures.isEmpty()) {
            resultFeatures.addAll(extraResultFeatures);
        }
        try {
            List modelManagerClasses = this.getServiceProviderClasses(model.getClass());
            for (Class modelManagerClazz : modelManagerClasses) {
                Functionality functionality = modelManagerClazz.getAnnotation(Functionality.class);
                if (functionality != null) {
                    EnumSet<ResultFeature> providedResultFeatures = EnumSet.noneOf(ResultFeature.class);
                    providedResultFeatures.addAll(Arrays.asList(functionality.value()));
                    if (!providedResultFeatures.containsAll(resultFeatures)) continue;
                }
                Constructor constructor = ModelManagerFactory.findConstructor(modelManagerClazz);
                try {
                    ModelManager modelManager = (ModelManager)constructor.newInstance(pmml, model);
                    if (extraResultFeatures == null || extraResultFeatures.isEmpty()) return (S)modelManager;
                    modelManager.addResultFeatures(extraResultFeatures);
                    return (S)modelManager;
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (!(cause instanceof PMMLException)) throw ite;
                    if (!(cause instanceof InvalidMarkupException) && cause instanceof UnsupportedMarkupException) continue;
                    throw (PMMLException)cause;
                    throw new UnsupportedElementException((PMMLObject)model);
                }
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (PMMLException pe) {
            throw pe;
        }
    }

    private static Constructor<?> findConstructor(Class<?> serviceProviderClass) throws NoSuchMethodException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = serviceProviderClass.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 2 || !PMML.class.isAssignableFrom(parameterTypes[0]) || !Model.class.isAssignableFrom(parameterTypes[1])) continue;
            return constructor;
        }
        throw new NoSuchMethodException();
    }
}

