/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.api.properties;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.talend.components.api.properties.ComponentKeySource;
import org.talend.daikon.crypto.CipherSources;
import org.talend.daikon.crypto.Encryption;
import org.talend.daikon.crypto.KeySource;

public class ComponentEncryption {
    private static final String ENCRYPTION_PREFIX = "enc:";
    private static final Pattern REG_ENCRYPTED_DATA = Pattern.compile("^enc\\:system\\.encryption\\.key\\.v\\d\\:\\p{Print}+");
    private static final Logger LOGGER = Logger.getLogger(ComponentEncryption.class.getCanonicalName());
    private static final ThreadLocal<Properties> LOCALCACHEDALLKEYS = ThreadLocal.withInitial(() -> ComponentKeySource.loadAllKeys());

    private static ComponentKeySource getKeySource(String keyName, boolean isEncrypt) {
        Properties allKeys = LOCALCACHEDALLKEYS.get();
        ComponentKeySource ks = ComponentKeySource.key(allKeys, keyName, isEncrypt);
        try {
            if (ks.getKey() != null) {
                return ks;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Can not load key: " + keyName);
        }
        IllegalArgumentException e = new IllegalArgumentException("Can not load encryption key data: " + keyName);
        LOGGER.log(Level.SEVERE, e.getMessage(), e);
        throw e;
    }

    public static String encrypt(String src) {
        if (src == null || ComponentEncryption.isEncrypted(src)) {
            return src;
        }
        try {
            ComponentKeySource ks = ComponentEncryption.getKeySource("system.encryption.key.v", true);
            StringBuilder sb = new StringBuilder();
            sb.append(ENCRYPTION_PREFIX);
            sb.append(ks.getKeyName());
            sb.append(":");
            sb.append(new Encryption((KeySource)ks, CipherSources.getDefault()).encrypt(src));
            return sb.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static String decrypt(String src) {
        if (!ComponentEncryption.isEncrypted(src)) {
            return src;
        }
        try {
            String[] encryptedData = src.split("\\:");
            ComponentKeySource ks = ComponentEncryption.getKeySource(encryptedData[1], false);
            return new Encryption((KeySource)ks, CipherSources.getDefault()).decrypt(encryptedData[2]);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static boolean isEncrypted(String src) {
        return src != null && REG_ENCRYPTED_DATA.matcher(src).matches();
    }

    private ComponentEncryption() {
    }
}

