/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.api.component.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.api.exception.ComponentException;
import org.talend.components.api.exception.error.ComponentsApiErrorCode;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.sandbox.MvnUrlParser;

public class DependenciesReader {
    private static final Logger LOG = LoggerFactory.getLogger(DependenciesReader.class);
    private String depTxtPath;
    private static ClassLoader classLoader = DependenciesReader.class.getClassLoader();

    public DependenciesReader(String mavenGroupId, String mavenArtifactId) {
        this.depTxtPath = DependenciesReader.computeDependenciesFilePath(mavenGroupId, mavenArtifactId);
    }

    public DependenciesReader(String depTxtPath) {
        this.depTxtPath = depTxtPath;
    }

    public Set<String> getDependencies(ClassLoader classLoader) throws IOException {
        ClassLoader zeClassLoader = classLoader;
        if (zeClassLoader == null) {
            zeClassLoader = DependenciesReader.classLoader;
        }
        try (InputStream depStream = zeClassLoader.getResourceAsStream(this.depTxtPath);){
            if (depStream == null) {
                throw new ComponentException((ErrorCode)ComponentsApiErrorCode.COMPUTE_DEPENDENCIES_FAILED, ExceptionContext.withBuilder().put("path", (Object)this.depTxtPath).build());
            }
            Set<String> set = this.parseDependencies(depStream);
            return set;
        }
    }

    public Set<String> parseDependencies(InputStream depStream) throws IOException {
        HashSet<String> mvnUris = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(depStream, "UTF-8"));
        while (reader.ready()) {
            String line = reader.readLine();
            if (!this.isRequiredDependency(line)) continue;
            mvnUris.add(this.parseMvnUri(line));
        }
        return mvnUris;
    }

    private boolean isRequiredDependency(String dependencyLine) {
        boolean result = StringUtils.countMatches((CharSequence)dependencyLine, (CharSequence)":") > 3 && !dependencyLine.endsWith("test") && !dependencyLine.endsWith("system");
        return result;
    }

    public String getDependencyFilePath() {
        return this.depTxtPath;
    }

    public static String computeDependenciesFilePath(String mavenGroupId, String mavenArtifactId) {
        return "META-INF/maven/" + mavenGroupId + "/" + mavenArtifactId + "/dependencies.txt";
    }

    String parseMvnUri(String dependencyString) {
        String trimedDependency = dependencyString.trim();
        String[] splitedDependency = trimedDependency.split(":");
        String groupId = splitedDependency[0];
        String artifactId = splitedDependency[1];
        String type = splitedDependency[2];
        String classifier = null;
        String version = null;
        if (splitedDependency.length > 5) {
            classifier = splitedDependency[3];
            version = splitedDependency[4];
        } else {
            version = splitedDependency[3];
        }
        return "mvn:" + groupId + '/' + artifactId + '/' + version + '/' + type + (classifier != null ? '/' + classifier : "");
    }

    public static List<URL> extractDependencies(URL jarMvnUrl) {
        if (jarMvnUrl != null && "mvn".equals(jarMvnUrl.getProtocol())) {
            String pathToDepsFile = DependenciesReader.computeDependenciesFilePath(jarMvnUrl);
            return DependenciesReader.extractDepenencies(jarMvnUrl, pathToDepsFile);
        }
        LOG.error("trying to get depenencies from an non mvn URL :" + jarMvnUrl);
        return Collections.emptyList();
    }

    static String computeDependenciesFilePath(URL jarMvnUrl) {
        String protocol;
        String string = protocol = jarMvnUrl != null ? jarMvnUrl.getProtocol() : null;
        if ("mvn".equals(protocol)) {
            try {
                MvnUrlParser mvnUrlParser = new MvnUrlParser(jarMvnUrl.getPath());
                return DependenciesReader.computeDependenciesFilePath(mvnUrlParser.getGroup(), mvnUrlParser.getArtifact());
            }
            catch (MalformedURLException e) {
                throw TalendRuntimeException.createUnexpectedException((Throwable)e);
            }
        }
        throw new IllegalArgumentException("the URL [" + jarMvnUrl + "] should be have the mvn: protocol.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<URL> extractDepenencies(URL jarUrl, String pathToDepsFile) {
        DependenciesReader dependenciesReader = new DependenciesReader(pathToDepsFile);
        try (JarInputStream jarInputStream = new JarInputStream(jarUrl.openStream());){
            List<URL> list = DependenciesReader.extractDependencies(dependenciesReader, pathToDepsFile, jarInputStream);
            return list;
        }
        catch (IOException e) {
            throw new ComponentException(ComponentsApiErrorCode.COMPUTE_DEPENDENCIES_FAILED, e, ExceptionContext.withBuilder().put("path", (Object)pathToDepsFile).build());
        }
    }

    protected static List<URL> extractDependencies(DependenciesReader dependenciesReader, String depTxtPath, JarInputStream jarInputStream) throws IOException, MalformedURLException {
        DependenciesReader.locateDependencyFileEntry(jarInputStream, depTxtPath);
        Set<String> dependencies = dependenciesReader.parseDependencies(jarInputStream);
        ArrayList<URL> result = new ArrayList<URL>(dependencies.size());
        for (String urlString : dependencies) {
            result.add(new URL(urlString));
        }
        return result;
    }

    private static void locateDependencyFileEntry(JarInputStream jarInputStream, String depTxtPath) throws IOException {
        JarEntry nextJarEntry = jarInputStream.getNextJarEntry();
        while (nextJarEntry != null) {
            if (depTxtPath.equals(nextJarEntry.getName())) {
                return;
            }
            nextJarEntry = jarInputStream.getNextJarEntry();
        }
        throw new ComponentException((ErrorCode)ComponentsApiErrorCode.COMPUTE_DEPENDENCIES_FAILED, ExceptionContext.withBuilder().put("path", (Object)depTxtPath).build());
    }
}

