/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.api.component;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.talend.components.api.AbstractTopLevelDefinition;
import org.talend.components.api.component.ComponentDefinition;
import org.talend.components.api.component.ComponentImageType;
import org.talend.components.api.component.ConnectorTopology;
import org.talend.components.api.component.runtime.ExecutionEngine;
import org.talend.components.api.exception.error.ComponentsErrorCode;
import org.talend.components.api.properties.ComponentProperties;
import org.talend.daikon.NamedThing;
import org.talend.daikon.definition.DefinitionImageType;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.properties.PropertiesImpl;
import org.talend.daikon.properties.property.Property;

public abstract class AbstractComponentDefinition
extends AbstractTopLevelDefinition
implements ComponentDefinition {
    private String componentName;
    private final Set<ExecutionEngine> engines;
    public static final String AUTO = "Auto";
    public static final String NONE = "None";

    public AbstractComponentDefinition(String componentName, boolean allEngines) {
        this.componentName = componentName;
        this.engines = allEngines ? EnumSet.allOf(ExecutionEngine.class) : EnumSet.noneOf(ExecutionEngine.class);
        this.setupI18N((NamedThing[])new Property[]{RETURN_ERROR_MESSAGE_PROP, RETURN_REJECT_RECORD_COUNT_PROP, RETURN_SUCCESS_RECORD_COUNT_PROP, RETURN_TOTAL_RECORD_COUNT_PROP});
    }

    public AbstractComponentDefinition(String componentName, ExecutionEngine engine1, ExecutionEngine ... engineOthers) {
        this.componentName = componentName;
        this.engines = EnumSet.of(engine1, engineOthers);
        this.setupI18N((NamedThing[])new Property[]{RETURN_ERROR_MESSAGE_PROP, RETURN_REJECT_RECORD_COUNT_PROP, RETURN_SUCCESS_RECORD_COUNT_PROP, RETURN_TOTAL_RECORD_COUNT_PROP});
    }

    public String getName() {
        return this.componentName;
    }

    @Override
    public Set<ExecutionEngine> getSupportedExecutionEngines() {
        return this.engines;
    }

    @Override
    public boolean isSupportingExecutionEngines(ExecutionEngine executionEngine) {
        return this.engines.contains((Object)executionEngine);
    }

    protected void assertEngineCompatibility(ExecutionEngine engine) throws TalendRuntimeException {
        if (!this.getSupportedExecutionEngines().contains((Object)engine)) {
            this.throwIncompatibleEngineException(engine);
        }
    }

    protected void throwIncompatibleEngineException(ExecutionEngine engine) throws TalendRuntimeException {
        TalendRuntimeException.build((ErrorCode)ComponentsErrorCode.WRONG_EXECUTION_ENGINE).put("component", this.getName()).put("requested", engine == null ? "null" : engine.toString()).put("available", this.getSupportedExecutionEngines().toString()).throwIt();
    }

    protected void assertConnectorTopologyCompatibility(ConnectorTopology connectorTopology) throws TalendRuntimeException {
        if (!this.getSupportedConnectorTopologies().contains((Object)connectorTopology)) {
            this.throwIncompatibleConnectorTopologyException(connectorTopology);
        }
    }

    protected void throwIncompatibleConnectorTopologyException(ConnectorTopology connectorTopology) throws TalendRuntimeException {
        TalendRuntimeException.build((ErrorCode)ComponentsErrorCode.WRONG_CONNECTOR).put("component", this.getName()).put("requested", connectorTopology == null ? "null" : connectorTopology.toString()).put("available", this.getSupportedExecutionEngines().toString()).throwIt();
    }

    @Override
    @Deprecated
    public String getPngImagePath(ComponentImageType imageType) {
        switch (imageType) {
            case PALLETE_ICON_32X32: {
                return this.getImagePath(DefinitionImageType.PALETTE_ICON_32X32);
            }
        }
        return null;
    }

    @Override
    public String[] getFamilies() {
        return new String[0];
    }

    @Override
    protected String getI18nPrefix() {
        return "component.";
    }

    @Override
    @Deprecated
    public ComponentProperties createProperties() {
        ComponentProperties compProp = (ComponentProperties)PropertiesImpl.createNewInstance(this.getPropertiesClass(), (String)"root");
        compProp.init();
        return compProp;
    }

    @Override
    public ComponentProperties createRuntimeProperties() {
        ComponentProperties compProp = (ComponentProperties)PropertiesImpl.createNewInstance(this.getPropertiesClass(), (String)"root");
        compProp.initForRuntime();
        return compProp;
    }

    @Override
    public boolean supportsProperties(ComponentProperties ... properties) {
        Class<? extends ComponentProperties>[] supportedNestedClasses = this.getNestedCompatibleComponentPropertiesClass();
        ArrayList<Class<? extends ComponentProperties>> supportedClasses = new ArrayList<Class<? extends ComponentProperties>>(supportedNestedClasses.length);
        Collections.addAll(supportedClasses, supportedNestedClasses);
        supportedClasses.add(this.getPropertyClass());
        ArrayList classesToCheck = new ArrayList(properties.length);
        for (ComponentProperties cp : properties) {
            classesToCheck.add(cp.getClass());
        }
        return supportedClasses.containsAll(classesToCheck);
    }

    @Override
    public boolean isSchemaAutoPropagate() {
        return false;
    }

    @Override
    public boolean isDataAutoPropagate() {
        return false;
    }

    @Override
    public boolean isConditionalInputs() {
        return false;
    }

    @Override
    public boolean isRejectAfterClose() {
        return false;
    }

    @Override
    public boolean isStartable() {
        return this.getSupportedConnectorTopologies().contains((Object)ConnectorTopology.OUTGOING);
    }

    @Override
    public String getPartitioning() {
        return null;
    }

    public String toString() {
        return this.getName() + " (" + this.getDisplayName() + ") - " + this.getTitle() + "\n props: " + this.getPropertyClass();
    }

    @Override
    public Class<ComponentProperties> getPropertiesClass() {
        return this.getPropertyClass();
    }

    public abstract Class<? extends ComponentProperties> getPropertyClass();

    public Class<? extends ComponentProperties>[] getNestedCompatibleComponentPropertiesClass() {
        return (Class[])Array.newInstance(Class.class, 0);
    }

    public Class<? extends ComponentProperties>[] concatPropertiesClasses(Class<? extends ComponentProperties>[] first, Class<? extends ComponentProperties>[] second) {
        Class<? extends ComponentProperties>[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public <T extends NamedThing> T[] setupI18N(T[] namedThings) {
        for (T nt : namedThings) {
            nt.setI18nMessageFormatter(this.getI18nMessageFormatter());
        }
        return namedThings;
    }

    @Deprecated
    public String getImagePath() {
        return this.getImagePath(DefinitionImageType.PALETTE_ICON_32X32);
    }

    public String getImagePath(DefinitionImageType type) {
        switch (type) {
            case PALETTE_ICON_32X32: {
                return this.componentName + "_icon32.png";
            }
            case SVG_ICON: {
                return null;
            }
        }
        return null;
    }

    public String getIconKey() {
        return null;
    }

    @Override
    public List<String> getSupportedProducts() {
        return Arrays.asList("ALL");
    }

    @Override
    public boolean isParallelize() {
        return false;
    }
}

