/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dmg.pmml.Array;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Row;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JacksonUtil {
    private static XmlMapper mapper;

    public static XmlMapper mapper() {
        if (mapper == null) {
            mapper = JacksonUtil.createMapper(srcMapper -> AnnotationIntrospector.pair((AnnotationIntrospector)new JacksonAnnotationIntrospector(), (AnnotationIntrospector)new JaxbAnnotationIntrospector(srcMapper.getTypeFactory())));
        }
        return mapper;
    }

    private static XmlMapper createMapper(Function<XmlMapper, AnnotationIntrospector> getIntrospector) {
        XmlMapper mapper = (XmlMapper)((XmlMapper.Builder)XmlMapper.builder().defaultUseWrapper(false).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).enable(new ToXmlGenerator.Feature[]{ToXmlGenerator.Feature.WRITE_XML_DECLARATION}).build();
        mapper.getFactory().getXMLOutputFactory().setProperty("org.codehaus.stax2.automaticNsPrefix", "");
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Array.class, (JsonDeserializer)new StdDeserializer<Array>(Array.class){

            public Array deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
                TreeNode readTree = jp.getCodec().readTree(jp);
                Array array = new Array(Array.Type.STRING, "  ");
                Iterator fieldNames = readTree.fieldNames();
                while (fieldNames.hasNext()) {
                    String field;
                    switch (field = (String)fieldNames.next()) {
                        case "type": {
                            array.setType(Array.Type.fromValue(((TextNode)readTree.get(field)).asText()));
                            break;
                        }
                        case "": {
                            array.setValue(((TextNode)readTree.get(field)).asText());
                            break;
                        }
                    }
                }
                return array;
            }
        });
        module.addDeserializer(Row.class, (JsonDeserializer)new StdDeserializer<Row>(Row.class){

            public Row deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
                TreeNode readTree = jp.getCodec().readTree(jp);
                ObjectNode contentNode = (ObjectNode)readTree.get("content");
                Iterator elements = contentNode.fields();
                ArrayList<Object> content = new ArrayList<Object>();
                try {
                    DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                    builderFactory.setNamespaceAware(false);
                    builderFactory.setValidating(false);
                    Document document = builderFactory.newDocumentBuilder().newDocument();
                    elements.forEachRemaining(entry -> {
                        Element rowContent = document.createElement((String)entry.getKey());
                        rowContent.setTextContent(((JsonNode)entry.getValue()).textValue());
                        content.add(rowContent);
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return new Row(content);
            }
        });
        module.addDeserializer(Constant.class, (JsonDeserializer)new StdDeserializer<Constant>(Constant.class){

            public Constant deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
                TreeNode valueNode;
                TreeNode readTree = jp.getCodec().readTree(jp);
                Constant constant = new Constant();
                TreeNode dataTypeNode = readTree.get("dataType");
                if (dataTypeNode != null) {
                    constant.setDataType(DataType.fromValue(((TextNode)dataTypeNode).asText()));
                }
                if ((valueNode = readTree.get("")) != null) {
                    constant.setValue(((TextNode)valueNode).asText());
                }
                return constant;
            }
        });
        mapper.registerModule((Module)module);
        mapper.setAnnotationIntrospector(getIntrospector.apply(mapper));
        mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }
}

