/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InsertQuery {
    private static String INSERT = "INSERT INTO %s %s VALUES %s";
    private Headers headers;
    private Values values;
    private String targetTable;
    private Set<Integer> dateColumns;
    private DatabaseType dbType = DatabaseType.DEFAULT;

    InsertQuery(String targetTable) {
        this.targetTable = targetTable;
    }

    void setValues(List<String> row) {
        this.values = new Values(row);
    }

    void setHeaders(List<String> headers) {
        this.headers = new Headers(headers);
        this.setDateColumns(headers);
    }

    private void setDateColumns(List<String> headers) {
        this.dateColumns = new HashSet<Integer>();
        for (int i = 0; i < headers.size(); ++i) {
            String header = headers.get(i);
            if (header.equalsIgnoreCase("datum_pri")) {
                this.dateColumns.add(i);
            }
            if (!header.equalsIgnoreCase("datum_pro")) continue;
            this.dateColumns.add(i);
        }
    }

    private boolean isNumeric(String str) {
        return str.matches("(0(\\.\\d+)?$)|-?[1-9]\\d*(\\.\\d+)?$");
    }

    public String arrayToValuesString(List<? extends Object> array, String quotation) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            Object obj = array.get(i);
            if (obj == null || obj.equals("")) {
                sb.append((Object)null);
            } else if (this.dateColumns.contains(i)) {
                sb.append(String.format(this.dbType.getDateFormat(), obj));
            } else if (this.isNumeric(obj.toString())) {
                sb.append(obj.toString());
            } else {
                sb.append(quotation);
                sb.append(obj.toString());
                sb.append(quotation);
            }
            if (i >= array.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String arrayToValues(List<? extends Object> array, String quotation) {
        StringBuilder sb = new StringBuilder("(");
        sb.append(this.arrayToValuesString(array, quotation));
        sb.append(")");
        return sb.toString();
    }

    void setDbType(DatabaseType dbType) {
        this.dbType = dbType;
    }

    public String toString() {
        return String.format(INSERT, this.targetTable, this.headers, this.values);
    }

    private String arrayToString(List<? extends Object> array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            Object obj = array.get(i);
            sb.append(obj.toString());
            if (i >= array.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private class Values {
        List<String> rowValues;

        public Values() {
            this.rowValues = new ArrayList<String>();
        }

        public Values(List<String> valuesList) {
            this.rowValues = valuesList;
        }

        public String toString() {
            return InsertQuery.this.arrayToValues(this.rowValues, "'");
        }
    }

    private class Headers {
        List<String> headers;

        public Headers(List<String> headers) {
            this.headers = headers;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("(");
            sb.append(InsertQuery.this.arrayToString(this.headers));
            sb.append(")");
            return sb.toString();
        }
    }

    public static enum DatabaseType {
        ORACLE("TO_DATE('%s','yyyymmdd')"),
        INFORMIX("TO_DATE('%s','%%Y%%m%%d')"),
        DEFAULT("'%s'");

        private String dateFormat;

        private DatabaseType(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }
    }
}

