/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.util;

import cz.drg.clasificator.util.HeaderListReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HeaderList {
    private static final String NO_WRITABLE_DATA = "Writer has no data to write to target location.";
    private static final String NULL_HEADERS_OR_DATA = "Reader returned null for header or valid elements list data! Headers: %s Columns: %s";
    private static final String NULL_READER = "ValidityList reader cannot be null!";
    private static final String UNEQUAL_LENGTH_HEADERS_COLUMNS_DATA = "Unequal number of headers and columns from reader! Headers: %n Columns: %n";
    private static final String HEADER_NOT_FOUND = "Header '%s' does not exist in this validity list! Available headers: [%s]";
    protected Map<String, Integer> headerToColumn;
    protected List<List<String>> columnsWithoutHeader;
    protected int numberOfLines = 0;
    private HeaderListReader reader;

    public HeaderList(HeaderListReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(NULL_READER);
        }
        this.reader = reader;
        this.readData();
    }

    private void readData() {
        this.headerToColumn = this.reader.getHeadersWithIndexes();
        this.columnsWithoutHeader = this.reader.getColumnLists();
        this.numberOfLines = this.reader.getNumberOfLines();
        this.checkReadData();
    }

    protected void checkReadData() {
        if (this.headerToColumn == null || this.columnsWithoutHeader == null) {
            throw new IllegalArgumentException(String.format(NULL_HEADERS_OR_DATA, this.headerToColumn, this.columnsWithoutHeader));
        }
        if (this.numberOfLines != 0 && this.headerToColumn.size() != this.columnsWithoutHeader.size()) {
            throw new IllegalArgumentException(String.format(UNEQUAL_LENGTH_HEADERS_COLUMNS_DATA, this.headerToColumn.size(), this.columnsWithoutHeader.size()));
        }
    }

    public boolean hasHeader(String header) {
        return this.headerToColumn.containsKey(header);
    }

    public List<String> getColumnList(String header) {
        if (!this.hasHeader(header)) {
            throw new IllegalArgumentException(String.format(HEADER_NOT_FOUND, header, this.headerToColumn.keySet()));
        }
        return this.columnsWithoutHeader.get(this.headerToColumn.get(header));
    }

    public Integer getHeaderIndex(String header) {
        if (!this.hasHeader(header)) {
            throw new IllegalArgumentException(String.format(HEADER_NOT_FOUND, header, this.headerToColumn.keySet()));
        }
        return this.headerToColumn.get(header);
    }

    public String getValue(int index, String header) {
        return this.getColumnList(header).get(index);
    }

    public Map<String, String> getRow(int lineIndex) {
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String header : this.headerToColumn.keySet()) {
            result.put(header, this.getValue(lineIndex, header));
        }
        return result;
    }

    public List<String> getRowAsList(int lineIndex) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.columnsWithoutHeader.size(); ++i) {
            String rowValue = this.columnsWithoutHeader.get(i).get(lineIndex);
            result.add(rowValue);
        }
        return result;
    }

    public List<Map<String, String>> getRows() {
        return this.getRows(0, this.numberOfLines);
    }

    public List<Map<String, String>> getRows(int lineStartIndex, int linesAmmount) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (int i = 0; i < linesAmmount; ++i) {
            result.add(this.getRow(lineStartIndex + i));
        }
        return result;
    }

    public int numOfLines() {
        return this.numberOfLines;
    }

    public Map<String, Integer> getHeaderToColumn() {
        return this.headerToColumn;
    }

    public List<List<String>> getColumnsWithoutHeader() {
        return this.columnsWithoutHeader;
    }

    public List<List<String>> getValues() {
        ArrayList<List<String>> columsWithHeader = new ArrayList<List<String>>();
        columsWithHeader.add(this.getSortedHeaderList());
        for (int i = 0; i < this.numOfLines(); ++i) {
            columsWithHeader.add(this.getRowAsList(i));
        }
        return columsWithHeader;
    }

    private List<String> getSortedHeaderList() {
        ArrayList<Map.Entry<String, Integer>> headers = new ArrayList<Map.Entry<String, Integer>>(this.headerToColumn.entrySet());
        Collections.sort(headers, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        ArrayList<String> headerList = new ArrayList<String>();
        for (Map.Entry entry : headers) {
            headerList.add((String)entry.getKey());
        }
        return headerList;
    }
}

