/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.util;

import cz.drg.clasificator.util.OutputHelper;
import javax.management.Notification;
import javax.management.NotificationListener;

class GarbageListener
implements NotificationListener {
    private static final int MB = 0x100000;
    private static final double MAX_MEMORY_USAGE = 0.8;
    private final Runtime runtime = Runtime.getRuntime();

    GarbageListener() {
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        double currentTotalMem;
        double currentUsedMem;
        double currentMemoryUsage;
        if (notification.getType().equals("com.sun.management.gc.notification") && (currentMemoryUsage = (currentUsedMem = (currentTotalMem = this.getTotalMemory()) - this.getFreeMemory()) / currentTotalMem) > 0.8) {
            OutputHelper.dualLog(String.format("Maximum memory usage threshold exceeded. Currently using %.1f%% of provided memory [%.1fMB/%.1fMB] . Increase provided memory for JVM in application startup command using -Xmx,-Xms arguments.", currentMemoryUsage * 100.0, currentUsedMem, currentTotalMem));
            this.shutdown();
        }
    }

    private void shutdown() {
        OutputHelper.dualLog("Program will shutdown.");
        System.exit(0);
    }

    private double getFreeMemory() {
        return this.runtime.freeMemory() / 0x100000L;
    }

    private double getTotalMemory() {
        return this.runtime.totalMemory() / 0x100000L;
    }
}

