/*
 * Decompiled with CFR 0.152.
 */
package cz.drg.clasificator.readers;

import cz.drg.clasificator.readers.BaseReader;
import cz.drg.clasificator.setting.ProgramSettings;
import cz.drg.clasificator.setting.Settings;
import cz.drg.clasificator.util.OutputHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class SystemInReader
extends BaseReader {
    private static String DEFAULT_CHARSET;
    private static String DEFAULT_DELIMITER;
    private static String DEFAULT_PMML_INPUT_FILEPATH;
    private static ZipFile DEFAULT_PMML_INPUT;
    private static Charset CHARSET;

    public SystemInReader(ZipFile pmmlInput, String delimiter, String charsetName) {
        super(pmmlInput, delimiter);
        try {
            CHARSET = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException ex) {
            OutputHelper.dualLog(String.format("Charset with name '%s' is not supported by installed java-runtime environment. Using default charset from settings '%s'.", charsetName, DEFAULT_CHARSET));
            CHARSET = Charset.forName(DEFAULT_CHARSET);
        }
        this.init();
    }

    public SystemInReader() {
        this(DEFAULT_PMML_INPUT, DEFAULT_DELIMITER, DEFAULT_CHARSET);
    }

    private static void loadDefaults() {
        ProgramSettings programSettings = Settings.getProgramSettings();
        DEFAULT_PMML_INPUT_FILEPATH = programSettings.getDefaultPmmlPath();
        DEFAULT_CHARSET = programSettings.getDefaultCharset();
        DEFAULT_DELIMITER = programSettings.getDefaultDelimiter();
        try {
            DEFAULT_PMML_INPUT = new ZipFile(DEFAULT_PMML_INPUT_FILEPATH);
        }
        catch (IOException ex) {
            OutputHelper.dualLog("Error loading default PMML zip file: '" + DEFAULT_PMML_INPUT_FILEPATH + "'");
            System.exit(-1);
        }
    }

    @Override
    protected List<String> getData() {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, CHARSET));
        try {
            String s;
            while ((s = in.readLine()) != null && s.length() != 0) {
                lines.add(s);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SystemInReader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return lines;
    }

    @Override
    public boolean hasNextEntryBatch() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        SystemInReader.loadDefaults();
    }
}

