/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.Array;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.HasValueSet;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.visitors.AbstractVisitor;

public abstract class AbstractTreeModelTransformer
extends AbstractVisitor {
    public void pushParent(PMMLObject object) {
        super.pushParent(object);
        if (object instanceof Node) {
            this.enterNode((Node)object);
        } else if (object instanceof TreeModel) {
            this.enterTreeModel((TreeModel)object);
        }
    }

    public PMMLObject popParent() {
        PMMLObject object = super.popParent();
        if (object instanceof Node) {
            this.exitNode((Node)object);
        } else if (object instanceof TreeModel) {
            this.exitTreeModel((TreeModel)object);
        }
        return object;
    }

    public void enterNode(Node node) {
    }

    public void exitNode(Node node) {
    }

    public void enterTreeModel(TreeModel treeModel) {
    }

    public void exitTreeModel(TreeModel treeModel) {
    }

    protected Node getParentNode() {
        Deque parents = this.getParents();
        PMMLObject parent = (PMMLObject)parents.peekFirst();
        if (parent instanceof Node) {
            return (Node)parent;
        }
        if (parent instanceof TreeModel) {
            return null;
        }
        throw new IllegalStateException();
    }

    public Node getAncestorNode(java.util.function.Predicate<Node> predicate) {
        Deque parents = this.getParents();
        for (PMMLObject parent : parents) {
            if (parent instanceof Node) {
                Node node = (Node)parent;
                if (!predicate.test(node)) continue;
                return node;
            }
            if (parent instanceof TreeModel) {
                return null;
            }
            throw new IllegalStateException();
        }
        return null;
    }

    protected TreeModel getParentTreeModel() {
        Deque parents = this.getParents();
        for (PMMLObject parent : parents) {
            if (parent instanceof Node) continue;
            if (parent instanceof TreeModel) {
                return (TreeModel)parent;
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    protected static List<Node> swapChildren(Node node) {
        List children = node.getNodes();
        if (children.size() != 2) {
            throw new IllegalArgumentException();
        }
        Node firstChild = (Node)children.remove(0);
        children.add(1, firstChild);
        return children;
    }

    protected static void initScore(Node parentNode, Node node) {
        Object score = node.getScore();
        if (parentNode.hasScore()) {
            throw new IllegalArgumentException();
        }
        parentNode.setScore(score);
    }

    protected static void initScoreDistribution(Node parentNode, Node node) {
        Object score = node.getScore();
        Number recordCount = node.getRecordCount();
        if (parentNode.hasScore()) {
            throw new IllegalArgumentException();
        }
        parentNode.setScore(score);
        Number parentRecordCount = parentNode.getRecordCount();
        if (parentRecordCount != null) {
            throw new IllegalArgumentException();
        }
        parentNode.setRecordCount(recordCount);
        if (parentNode.hasScoreDistributions()) {
            throw new IllegalArgumentException();
        }
        if (node.hasScoreDistributions()) {
            List scoreDistributions = node.getScoreDistributions();
            List parentScoreDistributions = parentNode.getScoreDistributions();
            if (!parentScoreDistributions.isEmpty()) {
                throw new IllegalArgumentException();
            }
            parentScoreDistributions.addAll(scoreDistributions);
        }
    }

    protected static void initDefaultChild(Node parentNode, Node node) {
        Object defaultChild = node.getDefaultChild();
        Object parentDefaultChild = parentNode.getDefaultChild();
        if (parentDefaultChild != null) {
            throw new IllegalArgumentException();
        }
        parentNode.setDefaultChild(defaultChild);
    }

    protected static void replaceChildWithGrandchildren(Node parentNode, Node node) {
        List parentChildren = parentNode.getNodes();
        int index = parentChildren.indexOf(node);
        if (index < 0 || index != parentChildren.size() - 1) {
            throw new IllegalArgumentException();
        }
        parentChildren.remove(index);
        if (node.hasNodes()) {
            List children = node.getNodes();
            parentChildren.addAll(index, children);
        }
    }

    protected static boolean equalsNode(Object defaultChild, Node node) {
        if (defaultChild instanceof Node) {
            return Objects.equals(defaultChild, node);
        }
        return Objects.equals(defaultChild, node.getId());
    }

    protected static boolean hasFieldReference(Predicate predicate, String fieldName) {
        if (predicate instanceof HasFieldReference) {
            HasFieldReference hasFieldReference = (HasFieldReference)predicate;
            return Objects.equals(hasFieldReference.requireField(), fieldName);
        }
        return false;
    }

    protected static boolean hasValue(Predicate predicate, String value) {
        if (predicate instanceof HasValue) {
            HasValue hasValue = (HasValue)predicate;
            return Objects.equals(hasValue.getValue(), value);
        }
        return false;
    }

    protected static boolean hasOperator(Predicate predicate, SimplePredicate.Operator operator) {
        if (predicate instanceof SimplePredicate) {
            SimplePredicate simplePredicate = (SimplePredicate)predicate;
            return operator == simplePredicate.requireOperator();
        }
        return false;
    }

    protected static boolean hasBooleanOperator(Predicate predicate, SimpleSetPredicate.BooleanOperator booleanOperator) {
        if (predicate instanceof SimpleSetPredicate) {
            SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)predicate;
            return booleanOperator == simpleSetPredicate.requireBooleanOperator();
        }
        return false;
    }

    protected static void checkFieldReference(Predicate left, Predicate right) {
        AbstractTreeModelTransformer.checkFieldReference((HasFieldReference)left, (HasFieldReference)right);
    }

    protected static void checkFieldReference(HasFieldReference<?> left, HasFieldReference<?> right) {
        String rightFieldName;
        String leftFieldName = left.requireField();
        if (!Objects.equals(leftFieldName, rightFieldName = right.requireField())) {
            throw new IllegalArgumentException("Field names " + leftFieldName + " and " + rightFieldName + " are not the same");
        }
    }

    protected static void checkValue(Predicate left, Predicate right) {
        AbstractTreeModelTransformer.checkValue((HasValue)left, (HasValue)right);
    }

    protected static void checkValue(HasValue<?> left, HasValue<?> right) {
        Object rightValue;
        Object leftValue = left.getValue();
        if (!Objects.equals(leftValue, rightValue = right.getValue())) {
            throw new IllegalArgumentException("Field values " + leftValue + " and " + rightValue + " are not the same");
        }
    }

    protected static void checkValueSet(Predicate left, Predicate right) {
        AbstractTreeModelTransformer.checkValueSet((HasValueSet)left, (HasValueSet)right);
    }

    protected static void checkValueSet(HasValueSet<?> left, HasValueSet<?> right) {
        Array leftArray = left.requireArray();
        Array rightArray = right.requireArray();
        if (!Objects.equals(leftArray.getValue(), rightArray.getValue())) {
            throw new IllegalArgumentException("Field value sets " + leftArray.getValue() + " and " + rightArray.getValue() + " are not the same");
        }
    }
}

